package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appliedPolicies", 
    "checkinDateTime", 
    "deviceName", 
    "devicePlatform", 
    "devicePlatformVersion", 
    "errorMessage", 
    "userId", 
    "userPrincipalName", 
    "wasSuccessful"})
@JsonInclude(Include.NON_NULL)
public class OfficeClientCheckinStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appliedPolicies")
    protected List<String> appliedPolicies;

    @JsonProperty("appliedPolicies@nextLink")
    protected String appliedPoliciesNextLink;

    @JsonProperty("checkinDateTime")
    protected OffsetDateTime checkinDateTime;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("devicePlatform")
    protected String devicePlatform;

    @JsonProperty("devicePlatformVersion")
    protected String devicePlatformVersion;

    @JsonProperty("errorMessage")
    protected String errorMessage;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("wasSuccessful")
    protected Boolean wasSuccessful;

    protected OfficeClientCheckinStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeClientCheckinStatus";
    }

    @Property(name="appliedPolicies")
    @JsonIgnore
    public CollectionPage<String> getAppliedPolicies() {
        return new CollectionPage<String>(contextPath, String.class, this.appliedPolicies, Optional.ofNullable(appliedPoliciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appliedPolicies")
    @JsonIgnore
    public CollectionPage<String> getAppliedPolicies(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.appliedPolicies, Optional.ofNullable(appliedPoliciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="checkinDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCheckinDateTime() {
        return Optional.ofNullable(checkinDateTime);
    }

    public OfficeClientCheckinStatus withCheckinDateTime(OffsetDateTime checkinDateTime) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.checkinDateTime = checkinDateTime;
        return _x;
    }

    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    public OfficeClientCheckinStatus withDeviceName(String deviceName) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.deviceName = deviceName;
        return _x;
    }

    @Property(name="devicePlatform")
    @JsonIgnore
    public Optional<String> getDevicePlatform() {
        return Optional.ofNullable(devicePlatform);
    }

    public OfficeClientCheckinStatus withDevicePlatform(String devicePlatform) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.devicePlatform = devicePlatform;
        return _x;
    }

    @Property(name="devicePlatformVersion")
    @JsonIgnore
    public Optional<String> getDevicePlatformVersion() {
        return Optional.ofNullable(devicePlatformVersion);
    }

    public OfficeClientCheckinStatus withDevicePlatformVersion(String devicePlatformVersion) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.devicePlatformVersion = devicePlatformVersion;
        return _x;
    }

    @Property(name="errorMessage")
    @JsonIgnore
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    public OfficeClientCheckinStatus withErrorMessage(String errorMessage) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.errorMessage = errorMessage;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public OfficeClientCheckinStatus withUserId(String userId) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public OfficeClientCheckinStatus withUserPrincipalName(String userPrincipalName) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="wasSuccessful")
    @JsonIgnore
    public Optional<Boolean> getWasSuccessful() {
        return Optional.ofNullable(wasSuccessful);
    }

    public OfficeClientCheckinStatus withWasSuccessful(Boolean wasSuccessful) {
        OfficeClientCheckinStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeClientCheckinStatus");
        _x.wasSuccessful = wasSuccessful;
        return _x;
    }

    public OfficeClientCheckinStatus withUnmappedField(String name, Object value) {
        OfficeClientCheckinStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> appliedPolicies;
        private String appliedPoliciesNextLink;
        private OffsetDateTime checkinDateTime;
        private String deviceName;
        private String devicePlatform;
        private String devicePlatformVersion;
        private String errorMessage;
        private String userId;
        private String userPrincipalName;
        private Boolean wasSuccessful;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appliedPolicies(List<String> appliedPolicies) {
            this.appliedPolicies = appliedPolicies;
            this.changedFields = changedFields.add("appliedPolicies");
            return this;
        }

        public Builder appliedPolicies(String... appliedPolicies) {
            return appliedPolicies(Arrays.asList(appliedPolicies));
        }

        public Builder appliedPoliciesNextLink(String appliedPoliciesNextLink) {
            this.appliedPoliciesNextLink = appliedPoliciesNextLink;
            this.changedFields = changedFields.add("appliedPolicies");
            return this;
        }

        public Builder checkinDateTime(OffsetDateTime checkinDateTime) {
            this.checkinDateTime = checkinDateTime;
            this.changedFields = changedFields.add("checkinDateTime");
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public Builder devicePlatform(String devicePlatform) {
            this.devicePlatform = devicePlatform;
            this.changedFields = changedFields.add("devicePlatform");
            return this;
        }

        public Builder devicePlatformVersion(String devicePlatformVersion) {
            this.devicePlatformVersion = devicePlatformVersion;
            this.changedFields = changedFields.add("devicePlatformVersion");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.changedFields = changedFields.add("errorMessage");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder wasSuccessful(Boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.changedFields = changedFields.add("wasSuccessful");
            return this;
        }

        public OfficeClientCheckinStatus build() {
            OfficeClientCheckinStatus _x = new OfficeClientCheckinStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.officeClientCheckinStatus";
            _x.appliedPolicies = appliedPolicies;
            _x.appliedPoliciesNextLink = appliedPoliciesNextLink;
            _x.checkinDateTime = checkinDateTime;
            _x.deviceName = deviceName;
            _x.devicePlatform = devicePlatform;
            _x.devicePlatformVersion = devicePlatformVersion;
            _x.errorMessage = errorMessage;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            _x.wasSuccessful = wasSuccessful;
            return _x;
        }
    }

    private OfficeClientCheckinStatus _copy() {
        OfficeClientCheckinStatus _x = new OfficeClientCheckinStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appliedPolicies = appliedPolicies;
        _x.checkinDateTime = checkinDateTime;
        _x.deviceName = deviceName;
        _x.devicePlatform = devicePlatform;
        _x.devicePlatformVersion = devicePlatformVersion;
        _x.errorMessage = errorMessage;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        _x.wasSuccessful = wasSuccessful;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeClientCheckinStatus[");
        b.append("appliedPolicies=");
        b.append(this.appliedPolicies);
        b.append(", ");
        b.append("checkinDateTime=");
        b.append(this.checkinDateTime);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("devicePlatform=");
        b.append(this.devicePlatform);
        b.append(", ");
        b.append("devicePlatformVersion=");
        b.append(this.devicePlatformVersion);
        b.append(", ");
        b.append("errorMessage=");
        b.append(this.errorMessage);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("wasSuccessful=");
        b.append(this.wasSuccessful);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
