package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“OEM Warranty information for a given device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "additionalWarranties", 
    "baseWarranties", 
    "deviceConfigurationUrl", 
    "deviceWarrantyUrl"})
@JsonInclude(Include.NON_NULL)
public class OemWarranty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("additionalWarranties")
    protected List<WarrantyOffer> additionalWarranties;

    @JsonProperty("additionalWarranties@nextLink")
    protected String additionalWarrantiesNextLink;

    @JsonProperty("baseWarranties")
    protected List<WarrantyOffer> baseWarranties;

    @JsonProperty("baseWarranties@nextLink")
    protected String baseWarrantiesNextLink;

    @JsonProperty("deviceConfigurationUrl")
    protected String deviceConfigurationUrl;

    @JsonProperty("deviceWarrantyUrl")
    protected String deviceWarrantyUrl;

    protected OemWarranty() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.oemWarranty";
    }

    /**
     * <i>“List of additional warranty offers. This collection can contain a maximum of 100
     * elements.”</i>
     * 
     * @return property additionalWarranties
     */
    @Property(name="additionalWarranties")
    @JsonIgnore
    public CollectionPage<WarrantyOffer> getAdditionalWarranties() {
        return new CollectionPage<WarrantyOffer>(contextPath, WarrantyOffer.class, this.additionalWarranties, Optional.ofNullable(additionalWarrantiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of additional warranty offers. This collection can contain a maximum of 100
     * elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property additionalWarranties
     */
    @Property(name="additionalWarranties")
    @JsonIgnore
    public CollectionPage<WarrantyOffer> getAdditionalWarranties(HttpRequestOptions options) {
        return new CollectionPage<WarrantyOffer>(contextPath, WarrantyOffer.class, this.additionalWarranties, Optional.ofNullable(additionalWarrantiesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of base warranty offers. This collection can contain a maximum of 100
     * elements.”</i>
     * 
     * @return property baseWarranties
     */
    @Property(name="baseWarranties")
    @JsonIgnore
    public CollectionPage<WarrantyOffer> getBaseWarranties() {
        return new CollectionPage<WarrantyOffer>(contextPath, WarrantyOffer.class, this.baseWarranties, Optional.ofNullable(baseWarrantiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of base warranty offers. This collection can contain a maximum of 100
     * elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property baseWarranties
     */
    @Property(name="baseWarranties")
    @JsonIgnore
    public CollectionPage<WarrantyOffer> getBaseWarranties(HttpRequestOptions options) {
        return new CollectionPage<WarrantyOffer>(contextPath, WarrantyOffer.class, this.baseWarranties, Optional.ofNullable(baseWarrantiesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Device configuration page URL”</i>
     * 
     * @return property deviceConfigurationUrl
     */
    @Property(name="deviceConfigurationUrl")
    @JsonIgnore
    public Optional<String> getDeviceConfigurationUrl() {
        return Optional.ofNullable(deviceConfigurationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfigurationUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device configuration page URL”</i>
     * 
     * @param deviceConfigurationUrl
     *            new value of {@code deviceConfigurationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfigurationUrl} field changed
     */
    public OemWarranty withDeviceConfigurationUrl(String deviceConfigurationUrl) {
        OemWarranty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oemWarranty");
        _x.deviceConfigurationUrl = deviceConfigurationUrl;
        return _x;
    }

    /**
     * <i>“Device warranty page URL”</i>
     * 
     * @return property deviceWarrantyUrl
     */
    @Property(name="deviceWarrantyUrl")
    @JsonIgnore
    public Optional<String> getDeviceWarrantyUrl() {
        return Optional.ofNullable(deviceWarrantyUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceWarrantyUrl
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device warranty page URL”</i>
     * 
     * @param deviceWarrantyUrl
     *            new value of {@code deviceWarrantyUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceWarrantyUrl} field changed
     */
    public OemWarranty withDeviceWarrantyUrl(String deviceWarrantyUrl) {
        OemWarranty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oemWarranty");
        _x.deviceWarrantyUrl = deviceWarrantyUrl;
        return _x;
    }

    public OemWarranty withUnmappedField(String name, Object value) {
        OemWarranty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<WarrantyOffer> additionalWarranties;
        private String additionalWarrantiesNextLink;
        private List<WarrantyOffer> baseWarranties;
        private String baseWarrantiesNextLink;
        private String deviceConfigurationUrl;
        private String deviceWarrantyUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of additional warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param additionalWarranties
         *            value of {@code additionalWarranties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalWarranties(List<WarrantyOffer> additionalWarranties) {
            this.additionalWarranties = additionalWarranties;
            this.changedFields = changedFields.add("additionalWarranties");
            return this;
        }

        /**
         * <i>“List of additional warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param additionalWarranties
         *            value of {@code additionalWarranties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalWarranties(WarrantyOffer... additionalWarranties) {
            return additionalWarranties(Arrays.asList(additionalWarranties));
        }

        /**
         * <i>“List of additional warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param additionalWarrantiesNextLink
         *            value of {@code additionalWarranties@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder additionalWarrantiesNextLink(String additionalWarrantiesNextLink) {
            this.additionalWarrantiesNextLink = additionalWarrantiesNextLink;
            this.changedFields = changedFields.add("additionalWarranties");
            return this;
        }

        /**
         * <i>“List of base warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param baseWarranties
         *            value of {@code baseWarranties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder baseWarranties(List<WarrantyOffer> baseWarranties) {
            this.baseWarranties = baseWarranties;
            this.changedFields = changedFields.add("baseWarranties");
            return this;
        }

        /**
         * <i>“List of base warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param baseWarranties
         *            value of {@code baseWarranties} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder baseWarranties(WarrantyOffer... baseWarranties) {
            return baseWarranties(Arrays.asList(baseWarranties));
        }

        /**
         * <i>“List of base warranty offers. This collection can contain a maximum of 100
         * elements.”</i>
         * 
         * @param baseWarrantiesNextLink
         *            value of {@code baseWarranties@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder baseWarrantiesNextLink(String baseWarrantiesNextLink) {
            this.baseWarrantiesNextLink = baseWarrantiesNextLink;
            this.changedFields = changedFields.add("baseWarranties");
            return this;
        }

        /**
         * <i>“Device configuration page URL”</i>
         * 
         * @param deviceConfigurationUrl
         *            value of {@code deviceConfigurationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfigurationUrl(String deviceConfigurationUrl) {
            this.deviceConfigurationUrl = deviceConfigurationUrl;
            this.changedFields = changedFields.add("deviceConfigurationUrl");
            return this;
        }

        /**
         * <i>“Device warranty page URL”</i>
         * 
         * @param deviceWarrantyUrl
         *            value of {@code deviceWarrantyUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceWarrantyUrl(String deviceWarrantyUrl) {
            this.deviceWarrantyUrl = deviceWarrantyUrl;
            this.changedFields = changedFields.add("deviceWarrantyUrl");
            return this;
        }

        public OemWarranty build() {
            OemWarranty _x = new OemWarranty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.oemWarranty";
            _x.additionalWarranties = additionalWarranties;
            _x.additionalWarrantiesNextLink = additionalWarrantiesNextLink;
            _x.baseWarranties = baseWarranties;
            _x.baseWarrantiesNextLink = baseWarrantiesNextLink;
            _x.deviceConfigurationUrl = deviceConfigurationUrl;
            _x.deviceWarrantyUrl = deviceWarrantyUrl;
            return _x;
        }
    }

    private OemWarranty _copy() {
        OemWarranty _x = new OemWarranty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.additionalWarranties = additionalWarranties;
        _x.baseWarranties = baseWarranties;
        _x.deviceConfigurationUrl = deviceConfigurationUrl;
        _x.deviceWarrantyUrl = deviceWarrantyUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OemWarranty[");
        b.append("additionalWarranties=");
        b.append(this.additionalWarranties);
        b.append(", ");
        b.append("baseWarranties=");
        b.append(this.baseWarranties);
        b.append(", ");
        b.append("deviceConfigurationUrl=");
        b.append(this.deviceConfigurationUrl);
        b.append(", ");
        b.append("deviceWarrantyUrl=");
        b.append(this.deviceWarrantyUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
