package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Number Range definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lowerNumber", 
    "upperNumber"})
@JsonInclude(Include.NON_NULL)
public class NumberRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lowerNumber")
    protected Integer lowerNumber;

    @JsonProperty("upperNumber")
    protected Integer upperNumber;

    protected NumberRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.numberRange";
    }

    /**
     * <i>“Lower number.”</i>
     * 
     * @return property lowerNumber
     */
    @Property(name="lowerNumber")
    @JsonIgnore
    public Optional<Integer> getLowerNumber() {
        return Optional.ofNullable(lowerNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lowerNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Lower number.”</i>
     * 
     * @param lowerNumber
     *            new value of {@code lowerNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lowerNumber} field changed
     */
    public NumberRange withLowerNumber(Integer lowerNumber) {
        NumberRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberRange");
        _x.lowerNumber = lowerNumber;
        return _x;
    }

    /**
     * <i>“Upper number.”</i>
     * 
     * @return property upperNumber
     */
    @Property(name="upperNumber")
    @JsonIgnore
    public Optional<Integer> getUpperNumber() {
        return Optional.ofNullable(upperNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code upperNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Upper number.”</i>
     * 
     * @param upperNumber
     *            new value of {@code upperNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upperNumber} field changed
     */
    public NumberRange withUpperNumber(Integer upperNumber) {
        NumberRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberRange");
        _x.upperNumber = upperNumber;
        return _x;
    }

    public NumberRange withUnmappedField(String name, Object value) {
        NumberRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer lowerNumber;
        private Integer upperNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Lower number.”</i>
         * 
         * @param lowerNumber
         *            value of {@code lowerNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lowerNumber(Integer lowerNumber) {
            this.lowerNumber = lowerNumber;
            this.changedFields = changedFields.add("lowerNumber");
            return this;
        }

        /**
         * <i>“Upper number.”</i>
         * 
         * @param upperNumber
         *            value of {@code upperNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upperNumber(Integer upperNumber) {
            this.upperNumber = upperNumber;
            this.changedFields = changedFields.add("upperNumber");
            return this;
        }

        public NumberRange build() {
            NumberRange _x = new NumberRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.numberRange";
            _x.lowerNumber = lowerNumber;
            _x.upperNumber = upperNumber;
            return _x;
        }
    }

    private NumberRange _copy() {
        NumberRange _x = new NumberRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lowerNumber = lowerNumber;
        _x.upperNumber = upperNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NumberRange[");
        b.append("lowerNumber=");
        b.append(this.lowerNumber);
        b.append(", ");
        b.append("upperNumber=");
        b.append(this.upperNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
