package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.NetworkType;

@JsonPropertyOrder({
    "@odata.type", 
    "networkNames", 
    "networkType"})
@JsonInclude(Include.NON_NULL)
public class NetworkLocationDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("networkNames")
    protected List<String> networkNames;

    @JsonProperty("networkNames@nextLink")
    protected String networkNamesNextLink;

    @JsonProperty("networkType")
    protected NetworkType networkType;

    protected NetworkLocationDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.networkLocationDetail";
    }

    @Property(name="networkNames")
    @JsonIgnore
    public CollectionPage<String> getNetworkNames() {
        return new CollectionPage<String>(contextPath, String.class, this.networkNames, Optional.ofNullable(networkNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="networkNames")
    @JsonIgnore
    public CollectionPage<String> getNetworkNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.networkNames, Optional.ofNullable(networkNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="networkType")
    @JsonIgnore
    public Optional<NetworkType> getNetworkType() {
        return Optional.ofNullable(networkType);
    }

    public NetworkLocationDetail withNetworkType(NetworkType networkType) {
        NetworkLocationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkLocationDetail");
        _x.networkType = networkType;
        return _x;
    }

    public NetworkLocationDetail withUnmappedField(String name, Object value) {
        NetworkLocationDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> networkNames;
        private String networkNamesNextLink;
        private NetworkType networkType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder networkNames(List<String> networkNames) {
            this.networkNames = networkNames;
            this.changedFields = changedFields.add("networkNames");
            return this;
        }

        public Builder networkNames(String... networkNames) {
            return networkNames(Arrays.asList(networkNames));
        }

        public Builder networkNamesNextLink(String networkNamesNextLink) {
            this.networkNamesNextLink = networkNamesNextLink;
            this.changedFields = changedFields.add("networkNames");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.changedFields = changedFields.add("networkType");
            return this;
        }

        public NetworkLocationDetail build() {
            NetworkLocationDetail _x = new NetworkLocationDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.networkLocationDetail";
            _x.networkNames = networkNames;
            _x.networkNamesNextLink = networkNamesNextLink;
            _x.networkType = networkType;
            return _x;
        }
    }

    private NetworkLocationDetail _copy() {
        NetworkLocationDetail _x = new NetworkLocationDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.networkNames = networkNames;
        _x.networkType = networkType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkLocationDetail[");
        b.append("networkNames=");
        b.append(this.networkNames);
        b.append(", ");
        b.append("networkType=");
        b.append(this.networkType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
