package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "ipV4Address", 
    "ipV6Address", 
    "localIpV6Address", 
    "macAddress"})
@JsonInclude(Include.NON_NULL)
public class NetworkInterface implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("ipV4Address")
    protected String ipV4Address;

    @JsonProperty("ipV6Address")
    protected String ipV6Address;

    @JsonProperty("localIpV6Address")
    protected String localIpV6Address;

    @JsonProperty("macAddress")
    protected String macAddress;

    protected NetworkInterface() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.networkInterface";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public NetworkInterface withDescription(String description) {
        NetworkInterface _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkInterface");
        _x.description = description;
        return _x;
    }

    @Property(name="ipV4Address")
    @JsonIgnore
    public Optional<String> getIpV4Address() {
        return Optional.ofNullable(ipV4Address);
    }

    public NetworkInterface withIpV4Address(String ipV4Address) {
        NetworkInterface _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkInterface");
        _x.ipV4Address = ipV4Address;
        return _x;
    }

    @Property(name="ipV6Address")
    @JsonIgnore
    public Optional<String> getIpV6Address() {
        return Optional.ofNullable(ipV6Address);
    }

    public NetworkInterface withIpV6Address(String ipV6Address) {
        NetworkInterface _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkInterface");
        _x.ipV6Address = ipV6Address;
        return _x;
    }

    @Property(name="localIpV6Address")
    @JsonIgnore
    public Optional<String> getLocalIpV6Address() {
        return Optional.ofNullable(localIpV6Address);
    }

    public NetworkInterface withLocalIpV6Address(String localIpV6Address) {
        NetworkInterface _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkInterface");
        _x.localIpV6Address = localIpV6Address;
        return _x;
    }

    @Property(name="macAddress")
    @JsonIgnore
    public Optional<String> getMacAddress() {
        return Optional.ofNullable(macAddress);
    }

    public NetworkInterface withMacAddress(String macAddress) {
        NetworkInterface _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkInterface");
        _x.macAddress = macAddress;
        return _x;
    }

    public NetworkInterface withUnmappedField(String name, Object value) {
        NetworkInterface _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String ipV4Address;
        private String ipV6Address;
        private String localIpV6Address;
        private String macAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder ipV4Address(String ipV4Address) {
            this.ipV4Address = ipV4Address;
            this.changedFields = changedFields.add("ipV4Address");
            return this;
        }

        public Builder ipV6Address(String ipV6Address) {
            this.ipV6Address = ipV6Address;
            this.changedFields = changedFields.add("ipV6Address");
            return this;
        }

        public Builder localIpV6Address(String localIpV6Address) {
            this.localIpV6Address = localIpV6Address;
            this.changedFields = changedFields.add("localIpV6Address");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.changedFields = changedFields.add("macAddress");
            return this;
        }

        public NetworkInterface build() {
            NetworkInterface _x = new NetworkInterface();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.networkInterface";
            _x.description = description;
            _x.ipV4Address = ipV4Address;
            _x.ipV6Address = ipV6Address;
            _x.localIpV6Address = localIpV6Address;
            _x.macAddress = macAddress;
            return _x;
        }
    }

    private NetworkInterface _copy() {
        NetworkInterface _x = new NetworkInterface();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.ipV4Address = ipV4Address;
        _x.ipV6Address = ipV6Address;
        _x.localIpV6Address = localIpV6Address;
        _x.macAddress = macAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkInterface[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("ipV4Address=");
        b.append(this.ipV4Address);
        b.append(", ");
        b.append("ipV6Address=");
        b.append(this.ipV6Address);
        b.append(", ");
        b.append("localIpV6Address=");
        b.append(this.localIpV6Address);
        b.append(", ");
        b.append("macAddress=");
        b.append(this.macAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
