package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;


/**
 * <i>“History Item contained in the Mobile App Troubleshooting Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MobileAppTroubleshootingDeviceCheckinHistory extends MobileAppTroubleshootingHistoryItem implements ODataType {

    protected MobileAppTroubleshootingDeviceCheckinHistory() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppTroubleshootingDeviceCheckinHistory";
    }

    public MobileAppTroubleshootingDeviceCheckinHistory withUnmappedField(String name, Object value) {
        MobileAppTroubleshootingDeviceCheckinHistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppTroubleshootingDeviceCheckinHistory() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime occurrenceDateTime;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder occurrenceDateTime(OffsetDateTime occurrenceDateTime) {
            this.occurrenceDateTime = occurrenceDateTime;
            this.changedFields = changedFields.add("occurrenceDateTime");
            return this;
        }

        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        public MobileAppTroubleshootingDeviceCheckinHistory build() {
            MobileAppTroubleshootingDeviceCheckinHistory _x = new MobileAppTroubleshootingDeviceCheckinHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppTroubleshootingDeviceCheckinHistory";
            _x.occurrenceDateTime = occurrenceDateTime;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            return _x;
        }
    }

    private MobileAppTroubleshootingDeviceCheckinHistory _copy() {
        MobileAppTroubleshootingDeviceCheckinHistory _x = new MobileAppTroubleshootingDeviceCheckinHistory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.occurrenceDateTime = occurrenceDateTime;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppTroubleshootingDeviceCheckinHistory[");
        b.append("occurrenceDateTime=");
        b.append(this.occurrenceDateTime);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
