package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“History Item contained in the Mobile App Troubleshooting Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "errorCode", 
    "runState"})
@JsonInclude(Include.NON_NULL)
public class MobileAppTroubleshootingAppPolicyCreationHistory extends MobileAppTroubleshootingHistoryItem implements ODataType {

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("runState")
    protected RunState runState;

    protected MobileAppTroubleshootingAppPolicyCreationHistory() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppTroubleshootingAppPolicyCreationHistory";
    }

    /**
     * <i>“Error code for the failure, empty if no failure.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code for the failure, empty if no failure.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public MobileAppTroubleshootingAppPolicyCreationHistory withErrorCode(String errorCode) {
        MobileAppTroubleshootingAppPolicyCreationHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingAppPolicyCreationHistory");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Status of the item.”</i>
     * 
     * @return property runState
     */
    @Property(name="runState")
    @JsonIgnore
    public Optional<RunState> getRunState() {
        return Optional.ofNullable(runState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runState} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Status of the item.”</i>
     * 
     * @param runState
     *            new value of {@code runState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runState} field changed
     */
    public MobileAppTroubleshootingAppPolicyCreationHistory withRunState(RunState runState) {
        MobileAppTroubleshootingAppPolicyCreationHistory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingAppPolicyCreationHistory");
        _x.runState = runState;
        return _x;
    }

    public MobileAppTroubleshootingAppPolicyCreationHistory withUnmappedField(String name, Object value) {
        MobileAppTroubleshootingAppPolicyCreationHistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppTroubleshootingAppPolicyCreationHistory() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime occurrenceDateTime;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private String errorCode;
        private RunState runState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder occurrenceDateTime(OffsetDateTime occurrenceDateTime) {
            this.occurrenceDateTime = occurrenceDateTime;
            this.changedFields = changedFields.add("occurrenceDateTime");
            return this;
        }

        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        /**
         * <i>“Error code for the failure, empty if no failure.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“Status of the item.”</i>
         * 
         * @param runState
         *            value of {@code runState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runState(RunState runState) {
            this.runState = runState;
            this.changedFields = changedFields.add("runState");
            return this;
        }

        public MobileAppTroubleshootingAppPolicyCreationHistory build() {
            MobileAppTroubleshootingAppPolicyCreationHistory _x = new MobileAppTroubleshootingAppPolicyCreationHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppTroubleshootingAppPolicyCreationHistory";
            _x.occurrenceDateTime = occurrenceDateTime;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            _x.errorCode = errorCode;
            _x.runState = runState;
            return _x;
        }
    }

    private MobileAppTroubleshootingAppPolicyCreationHistory _copy() {
        MobileAppTroubleshootingAppPolicyCreationHistory _x = new MobileAppTroubleshootingAppPolicyCreationHistory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.occurrenceDateTime = occurrenceDateTime;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        _x.errorCode = errorCode;
        _x.runState = runState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppTroubleshootingAppPolicyCreationHistory[");
        b.append("occurrenceDateTime=");
        b.append(this.occurrenceDateTime);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("runState=");
        b.append(this.runState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
