package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ResultantAppState;
import odata.msgraph.client.beta.enums.ResultantAppStateDetail;


/**
 * <i>“Describes the installation status details of the child app in the context of UPN
 * and device id.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "errorCode", 
    "installState", 
    "installStateDetail", 
    "sourceIds", 
    "targetDisplayName", 
    "targetId", 
    "targetLastSyncDateTime"})
@JsonInclude(Include.NON_NULL)
public class MobileAppRelationshipState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    @JsonProperty("installState")
    protected ResultantAppState installState;

    @JsonProperty("installStateDetail")
    protected ResultantAppStateDetail installStateDetail;

    @JsonProperty("sourceIds")
    protected List<String> sourceIds;

    @JsonProperty("sourceIds@nextLink")
    protected String sourceIdsNextLink;

    @JsonProperty("targetDisplayName")
    protected String targetDisplayName;

    @JsonProperty("targetId")
    protected String targetId;

    @JsonProperty("targetLastSyncDateTime")
    protected OffsetDateTime targetLastSyncDateTime;

    protected MobileAppRelationshipState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppRelationshipState";
    }

    /**
     * <i>“The corresponding device id.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The corresponding device id.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public MobileAppRelationshipState withDeviceId(String deviceId) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The error code for install or uninstall failures of target app.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code for install or uninstall failures of target app.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public MobileAppRelationshipState withErrorCode(Integer errorCode) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“The install state of the app of target app.”</i>
     * 
     * @return property installState
     */
    @Property(name="installState")
    @JsonIgnore
    public Optional<ResultantAppState> getInstallState() {
        return Optional.ofNullable(installState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The install state of the app of target app.”</i>
     * 
     * @param installState
     *            new value of {@code installState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installState} field changed
     */
    public MobileAppRelationshipState withInstallState(ResultantAppState installState) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.installState = installState;
        return _x;
    }

    /**
     * <i>“The install state detail of the app.”</i>
     * 
     * @return property installStateDetail
     */
    @Property(name="installStateDetail")
    @JsonIgnore
    public Optional<ResultantAppStateDetail> getInstallStateDetail() {
        return Optional.ofNullable(installStateDetail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installStateDetail} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The install state detail of the app.”</i>
     * 
     * @param installStateDetail
     *            new value of {@code installStateDetail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installStateDetail} field changed
     */
    public MobileAppRelationshipState withInstallStateDetail(ResultantAppStateDetail installStateDetail) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.installStateDetail = installStateDetail;
        return _x;
    }

    /**
     * <i>“The collection of source mobile app's ids.”</i>
     * 
     * @return property sourceIds
     */
    @Property(name="sourceIds")
    @JsonIgnore
    public CollectionPage<String> getSourceIds() {
        return new CollectionPage<String>(contextPath, String.class, this.sourceIds, Optional.ofNullable(sourceIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The collection of source mobile app's ids.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property sourceIds
     */
    @Property(name="sourceIds")
    @JsonIgnore
    public CollectionPage<String> getSourceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.sourceIds, Optional.ofNullable(sourceIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The related target app's display name.”</i>
     * 
     * @return property targetDisplayName
     */
    @Property(name="targetDisplayName")
    @JsonIgnore
    public Optional<String> getTargetDisplayName() {
        return Optional.ofNullable(targetDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The related target app's display name.”</i>
     * 
     * @param targetDisplayName
     *            new value of {@code targetDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetDisplayName} field changed
     */
    public MobileAppRelationshipState withTargetDisplayName(String targetDisplayName) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.targetDisplayName = targetDisplayName;
        return _x;
    }

    /**
     * <i>“The related target app's id.”</i>
     * 
     * @return property targetId
     */
    @Property(name="targetId")
    @JsonIgnore
    public Optional<String> getTargetId() {
        return Optional.ofNullable(targetId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The related target app's id.”</i>
     * 
     * @param targetId
     *            new value of {@code targetId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetId} field changed
     */
    public MobileAppRelationshipState withTargetId(String targetId) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.targetId = targetId;
        return _x;
    }

    /**
     * <i>“The last sync time of the target app.”</i>
     * 
     * @return property targetLastSyncDateTime
     */
    @Property(name="targetLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTargetLastSyncDateTime() {
        return Optional.ofNullable(targetLastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetLastSyncDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last sync time of the target app.”</i>
     * 
     * @param targetLastSyncDateTime
     *            new value of {@code targetLastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetLastSyncDateTime} field changed
     */
    public MobileAppRelationshipState withTargetLastSyncDateTime(OffsetDateTime targetLastSyncDateTime) {
        MobileAppRelationshipState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppRelationshipState");
        _x.targetLastSyncDateTime = targetLastSyncDateTime;
        return _x;
    }

    public MobileAppRelationshipState withUnmappedField(String name, Object value) {
        MobileAppRelationshipState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceId;
        private Integer errorCode;
        private ResultantAppState installState;
        private ResultantAppStateDetail installStateDetail;
        private List<String> sourceIds;
        private String sourceIdsNextLink;
        private String targetDisplayName;
        private String targetId;
        private OffsetDateTime targetLastSyncDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The corresponding device id.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The error code for install or uninstall failures of target app.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“The install state of the app of target app.”</i>
         * 
         * @param installState
         *            value of {@code installState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installState(ResultantAppState installState) {
            this.installState = installState;
            this.changedFields = changedFields.add("installState");
            return this;
        }

        /**
         * <i>“The install state detail of the app.”</i>
         * 
         * @param installStateDetail
         *            value of {@code installStateDetail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installStateDetail(ResultantAppStateDetail installStateDetail) {
            this.installStateDetail = installStateDetail;
            this.changedFields = changedFields.add("installStateDetail");
            return this;
        }

        /**
         * <i>“The collection of source mobile app's ids.”</i>
         * 
         * @param sourceIds
         *            value of {@code sourceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceIds(List<String> sourceIds) {
            this.sourceIds = sourceIds;
            this.changedFields = changedFields.add("sourceIds");
            return this;
        }

        /**
         * <i>“The collection of source mobile app's ids.”</i>
         * 
         * @param sourceIds
         *            value of {@code sourceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceIds(String... sourceIds) {
            return sourceIds(Arrays.asList(sourceIds));
        }

        /**
         * <i>“The collection of source mobile app's ids.”</i>
         * 
         * @param sourceIdsNextLink
         *            value of {@code sourceIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceIdsNextLink(String sourceIdsNextLink) {
            this.sourceIdsNextLink = sourceIdsNextLink;
            this.changedFields = changedFields.add("sourceIds");
            return this;
        }

        /**
         * <i>“The related target app's display name.”</i>
         * 
         * @param targetDisplayName
         *            value of {@code targetDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetDisplayName(String targetDisplayName) {
            this.targetDisplayName = targetDisplayName;
            this.changedFields = changedFields.add("targetDisplayName");
            return this;
        }

        /**
         * <i>“The related target app's id.”</i>
         * 
         * @param targetId
         *            value of {@code targetId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.changedFields = changedFields.add("targetId");
            return this;
        }

        /**
         * <i>“The last sync time of the target app.”</i>
         * 
         * @param targetLastSyncDateTime
         *            value of {@code targetLastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetLastSyncDateTime(OffsetDateTime targetLastSyncDateTime) {
            this.targetLastSyncDateTime = targetLastSyncDateTime;
            this.changedFields = changedFields.add("targetLastSyncDateTime");
            return this;
        }

        public MobileAppRelationshipState build() {
            MobileAppRelationshipState _x = new MobileAppRelationshipState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppRelationshipState";
            _x.deviceId = deviceId;
            _x.errorCode = errorCode;
            _x.installState = installState;
            _x.installStateDetail = installStateDetail;
            _x.sourceIds = sourceIds;
            _x.sourceIdsNextLink = sourceIdsNextLink;
            _x.targetDisplayName = targetDisplayName;
            _x.targetId = targetId;
            _x.targetLastSyncDateTime = targetLastSyncDateTime;
            return _x;
        }
    }

    private MobileAppRelationshipState _copy() {
        MobileAppRelationshipState _x = new MobileAppRelationshipState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceId = deviceId;
        _x.errorCode = errorCode;
        _x.installState = installState;
        _x.installStateDetail = installStateDetail;
        _x.sourceIds = sourceIds;
        _x.targetDisplayName = targetDisplayName;
        _x.targetId = targetId;
        _x.targetLastSyncDateTime = targetLastSyncDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppRelationshipState[");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("installState=");
        b.append(this.installState);
        b.append(", ");
        b.append("installStateDetail=");
        b.append(this.installStateDetail);
        b.append(", ");
        b.append("sourceIds=");
        b.append(this.sourceIds);
        b.append(", ");
        b.append("targetDisplayName=");
        b.append(this.targetDisplayName);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("targetLastSyncDateTime=");
        b.append(this.targetLastSyncDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
