package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MobileAppIntent;
import odata.msgraph.client.beta.enums.ResultantAppState;


/**
 * <i>“Mobile App Intent and Install State for a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationId", 
    "displayName", 
    "displayVersion", 
    "installState", 
    "mobileAppIntent", 
    "supportedDeviceTypes"})
@JsonInclude(Include.NON_NULL)
public class MobileAppIntentAndStateDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("displayVersion")
    protected String displayVersion;

    @JsonProperty("installState")
    protected ResultantAppState installState;

    @JsonProperty("mobileAppIntent")
    protected MobileAppIntent mobileAppIntent;

    @JsonProperty("supportedDeviceTypes")
    protected List<MobileAppSupportedDeviceType> supportedDeviceTypes;

    @JsonProperty("supportedDeviceTypes@nextLink")
    protected String supportedDeviceTypesNextLink;

    protected MobileAppIntentAndStateDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppIntentAndStateDetail";
    }

    /**
     * <i>“MobieApp identifier.”</i>
     * 
     * @return property applicationId
     */
    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“MobieApp identifier.”</i>
     * 
     * @param applicationId
     *            new value of {@code applicationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationId} field changed
     */
    public MobileAppIntentAndStateDetail withApplicationId(String applicationId) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndStateDetail");
        _x.applicationId = applicationId;
        return _x;
    }

    /**
     * <i>“The admin provided or imported title of the app.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin provided or imported title of the app.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MobileAppIntentAndStateDetail withDisplayName(String displayName) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndStateDetail");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Human readable version of the application”</i>
     * 
     * @return property displayVersion
     */
    @Property(name="displayVersion")
    @JsonIgnore
    public Optional<String> getDisplayVersion() {
        return Optional.ofNullable(displayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Human readable version of the application”</i>
     * 
     * @param displayVersion
     *            new value of {@code displayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayVersion} field changed
     */
    public MobileAppIntentAndStateDetail withDisplayVersion(String displayVersion) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndStateDetail");
        _x.displayVersion = displayVersion;
        return _x;
    }

    /**
     * <i>“The install state of the app.”</i>
     * 
     * @return property installState
     */
    @Property(name="installState")
    @JsonIgnore
    public Optional<ResultantAppState> getInstallState() {
        return Optional.ofNullable(installState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code installState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The install state of the app.”</i>
     * 
     * @param installState
     *            new value of {@code installState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installState} field changed
     */
    public MobileAppIntentAndStateDetail withInstallState(ResultantAppState installState) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndStateDetail");
        _x.installState = installState;
        return _x;
    }

    /**
     * <i>“Mobile App Intent.”</i>
     * 
     * @return property mobileAppIntent
     */
    @Property(name="mobileAppIntent")
    @JsonIgnore
    public Optional<MobileAppIntent> getMobileAppIntent() {
        return Optional.ofNullable(mobileAppIntent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mobileAppIntent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Mobile App Intent.”</i>
     * 
     * @param mobileAppIntent
     *            new value of {@code mobileAppIntent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppIntent} field changed
     */
    public MobileAppIntentAndStateDetail withMobileAppIntent(MobileAppIntent mobileAppIntent) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppIntentAndStateDetail");
        _x.mobileAppIntent = mobileAppIntent;
        return _x;
    }

    /**
     * <i>“The supported platforms for the app.”</i>
     * 
     * @return property supportedDeviceTypes
     */
    @Property(name="supportedDeviceTypes")
    @JsonIgnore
    public CollectionPage<MobileAppSupportedDeviceType> getSupportedDeviceTypes() {
        return new CollectionPage<MobileAppSupportedDeviceType>(contextPath, MobileAppSupportedDeviceType.class, this.supportedDeviceTypes, Optional.ofNullable(supportedDeviceTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The supported platforms for the app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property supportedDeviceTypes
     */
    @Property(name="supportedDeviceTypes")
    @JsonIgnore
    public CollectionPage<MobileAppSupportedDeviceType> getSupportedDeviceTypes(HttpRequestOptions options) {
        return new CollectionPage<MobileAppSupportedDeviceType>(contextPath, MobileAppSupportedDeviceType.class, this.supportedDeviceTypes, Optional.ofNullable(supportedDeviceTypesNextLink), Collections.emptyList(), options);
    }

    public MobileAppIntentAndStateDetail withUnmappedField(String name, Object value) {
        MobileAppIntentAndStateDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationId;
        private String displayName;
        private String displayVersion;
        private ResultantAppState installState;
        private MobileAppIntent mobileAppIntent;
        private List<MobileAppSupportedDeviceType> supportedDeviceTypes;
        private String supportedDeviceTypesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“MobieApp identifier.”</i>
         * 
         * @param applicationId
         *            value of {@code applicationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        /**
         * <i>“The admin provided or imported title of the app.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Human readable version of the application”</i>
         * 
         * @param displayVersion
         *            value of {@code displayVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayVersion(String displayVersion) {
            this.displayVersion = displayVersion;
            this.changedFields = changedFields.add("displayVersion");
            return this;
        }

        /**
         * <i>“The install state of the app.”</i>
         * 
         * @param installState
         *            value of {@code installState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installState(ResultantAppState installState) {
            this.installState = installState;
            this.changedFields = changedFields.add("installState");
            return this;
        }

        /**
         * <i>“Mobile App Intent.”</i>
         * 
         * @param mobileAppIntent
         *            value of {@code mobileAppIntent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppIntent(MobileAppIntent mobileAppIntent) {
            this.mobileAppIntent = mobileAppIntent;
            this.changedFields = changedFields.add("mobileAppIntent");
            return this;
        }

        /**
         * <i>“The supported platforms for the app.”</i>
         * 
         * @param supportedDeviceTypes
         *            value of {@code supportedDeviceTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDeviceTypes(List<MobileAppSupportedDeviceType> supportedDeviceTypes) {
            this.supportedDeviceTypes = supportedDeviceTypes;
            this.changedFields = changedFields.add("supportedDeviceTypes");
            return this;
        }

        /**
         * <i>“The supported platforms for the app.”</i>
         * 
         * @param supportedDeviceTypes
         *            value of {@code supportedDeviceTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDeviceTypes(MobileAppSupportedDeviceType... supportedDeviceTypes) {
            return supportedDeviceTypes(Arrays.asList(supportedDeviceTypes));
        }

        /**
         * <i>“The supported platforms for the app.”</i>
         * 
         * @param supportedDeviceTypesNextLink
         *            value of {@code supportedDeviceTypes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDeviceTypesNextLink(String supportedDeviceTypesNextLink) {
            this.supportedDeviceTypesNextLink = supportedDeviceTypesNextLink;
            this.changedFields = changedFields.add("supportedDeviceTypes");
            return this;
        }

        public MobileAppIntentAndStateDetail build() {
            MobileAppIntentAndStateDetail _x = new MobileAppIntentAndStateDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppIntentAndStateDetail";
            _x.applicationId = applicationId;
            _x.displayName = displayName;
            _x.displayVersion = displayVersion;
            _x.installState = installState;
            _x.mobileAppIntent = mobileAppIntent;
            _x.supportedDeviceTypes = supportedDeviceTypes;
            _x.supportedDeviceTypesNextLink = supportedDeviceTypesNextLink;
            return _x;
        }
    }

    private MobileAppIntentAndStateDetail _copy() {
        MobileAppIntentAndStateDetail _x = new MobileAppIntentAndStateDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationId = applicationId;
        _x.displayName = displayName;
        _x.displayVersion = displayVersion;
        _x.installState = installState;
        _x.mobileAppIntent = mobileAppIntent;
        _x.supportedDeviceTypes = supportedDeviceTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppIntentAndStateDetail[");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("displayVersion=");
        b.append(this.displayVersion);
        b.append(", ");
        b.append("installState=");
        b.append(this.installState);
        b.append(", ");
        b.append("mobileAppIntent=");
        b.append(this.mobileAppIntent);
        b.append(", ");
        b.append("supportedDeviceTypes=");
        b.append(this.supportedDeviceTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
