package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for a generic mime content.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class MimeContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("value")
    protected byte[] value;

    protected MimeContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mimeContent";
    }

    /**
     * <i>“Indicates the content mime type.”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates the content mime type.”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public MimeContent withType(String type) {
        MimeContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mimeContent");
        _x.type = type;
        return _x;
    }

    /**
     * <i>“The byte array that contains the actual content.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<byte[]> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The byte array that contains the actual content.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public MimeContent withValue(byte[] value) {
        MimeContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mimeContent");
        _x.value = value;
        return _x;
    }

    public MimeContent withUnmappedField(String name, Object value) {
        MimeContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String type;
        private byte[] value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Indicates the content mime type.”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        /**
         * <i>“The byte array that contains the actual content.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(byte[] value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public MimeContent build() {
            MimeContent _x = new MimeContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mimeContent";
            _x.type = type;
            _x.value = value;
            return _x;
        }
    }

    private MimeContent _copy() {
        MimeContent _x = new MimeContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.type = type;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MimeContent[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
