package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MicrosoftManagedDesktopType;

@JsonPropertyOrder({
    "@odata.type", 
    "profile", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftManagedDesktop implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("profile")
    protected String profile;

    @JsonProperty("type")
    protected MicrosoftManagedDesktopType type;

    protected MicrosoftManagedDesktop() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftManagedDesktop";
    }

    @Property(name="profile")
    @JsonIgnore
    public Optional<String> getProfile() {
        return Optional.ofNullable(profile);
    }

    public MicrosoftManagedDesktop withProfile(String profile) {
        MicrosoftManagedDesktop _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftManagedDesktop");
        _x.profile = profile;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<MicrosoftManagedDesktopType> getType() {
        return Optional.ofNullable(type);
    }

    public MicrosoftManagedDesktop withType(MicrosoftManagedDesktopType type) {
        MicrosoftManagedDesktop _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftManagedDesktop");
        _x.type = type;
        return _x;
    }

    public MicrosoftManagedDesktop withUnmappedField(String name, Object value) {
        MicrosoftManagedDesktop _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String profile;
        private MicrosoftManagedDesktopType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder profile(String profile) {
            this.profile = profile;
            this.changedFields = changedFields.add("profile");
            return this;
        }

        public Builder type(MicrosoftManagedDesktopType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public MicrosoftManagedDesktop build() {
            MicrosoftManagedDesktop _x = new MicrosoftManagedDesktop();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftManagedDesktop";
            _x.profile = profile;
            _x.type = type;
            return _x;
        }
    }

    private MicrosoftManagedDesktop _copy() {
        MicrosoftManagedDesktop _x = new MicrosoftManagedDesktop();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.profile = profile;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftManagedDesktop[");
        b.append("profile=");
        b.append(this.profile);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
