package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "initiator", 
    "members", 
    "visibleHistoryStartDateTime"})
@JsonInclude(Include.NON_NULL)
public class MembersAddedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("members")
    protected List<TeamworkUserIdentity> members;

    @JsonProperty("members@nextLink")
    protected String membersNextLink;

    @JsonProperty("visibleHistoryStartDateTime")
    protected OffsetDateTime visibleHistoryStartDateTime;

    protected MembersAddedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.membersAddedEventMessageDetail";
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public MembersAddedEventMessageDetail withInitiator(IdentitySet initiator) {
        MembersAddedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membersAddedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="members")
    @JsonIgnore
    public CollectionPage<TeamworkUserIdentity> getMembers() {
        return new CollectionPage<TeamworkUserIdentity>(contextPath, TeamworkUserIdentity.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="members")
    @JsonIgnore
    public CollectionPage<TeamworkUserIdentity> getMembers(HttpRequestOptions options) {
        return new CollectionPage<TeamworkUserIdentity>(contextPath, TeamworkUserIdentity.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), options);
    }

    @Property(name="visibleHistoryStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getVisibleHistoryStartDateTime() {
        return Optional.ofNullable(visibleHistoryStartDateTime);
    }

    public MembersAddedEventMessageDetail withVisibleHistoryStartDateTime(OffsetDateTime visibleHistoryStartDateTime) {
        MembersAddedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membersAddedEventMessageDetail");
        _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
        return _x;
    }

    public MembersAddedEventMessageDetail withUnmappedField(String name, Object value) {
        MembersAddedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMembersAddedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet initiator;
        private List<TeamworkUserIdentity> members;
        private String membersNextLink;
        private OffsetDateTime visibleHistoryStartDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder members(List<TeamworkUserIdentity> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(TeamworkUserIdentity... members) {
            return members(Arrays.asList(members));
        }

        public Builder membersNextLink(String membersNextLink) {
            this.membersNextLink = membersNextLink;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder visibleHistoryStartDateTime(OffsetDateTime visibleHistoryStartDateTime) {
            this.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
            this.changedFields = changedFields.add("visibleHistoryStartDateTime");
            return this;
        }

        public MembersAddedEventMessageDetail build() {
            MembersAddedEventMessageDetail _x = new MembersAddedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.membersAddedEventMessageDetail";
            _x.initiator = initiator;
            _x.members = members;
            _x.membersNextLink = membersNextLink;
            _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
            return _x;
        }
    }

    private MembersAddedEventMessageDetail _copy() {
        MembersAddedEventMessageDetail _x = new MembersAddedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiator = initiator;
        _x.members = members;
        _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MembersAddedEventMessageDetail[");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append(", ");
        b.append("visibleHistoryStartDateTime=");
        b.append(this.visibleHistoryStartDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
