package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "initiator", 
    "meetingChatEnabled", 
    "meetingChatId"})
@JsonInclude(Include.NON_NULL)
public class MeetingPolicyUpdatedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("meetingChatEnabled")
    protected Boolean meetingChatEnabled;

    @JsonProperty("meetingChatId")
    protected String meetingChatId;

    protected MeetingPolicyUpdatedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingPolicyUpdatedEventMessageDetail";
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public MeetingPolicyUpdatedEventMessageDetail withInitiator(IdentitySet initiator) {
        MeetingPolicyUpdatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingPolicyUpdatedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="meetingChatEnabled")
    @JsonIgnore
    public Optional<Boolean> getMeetingChatEnabled() {
        return Optional.ofNullable(meetingChatEnabled);
    }

    public MeetingPolicyUpdatedEventMessageDetail withMeetingChatEnabled(Boolean meetingChatEnabled) {
        MeetingPolicyUpdatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingPolicyUpdatedEventMessageDetail");
        _x.meetingChatEnabled = meetingChatEnabled;
        return _x;
    }

    @Property(name="meetingChatId")
    @JsonIgnore
    public Optional<String> getMeetingChatId() {
        return Optional.ofNullable(meetingChatId);
    }

    public MeetingPolicyUpdatedEventMessageDetail withMeetingChatId(String meetingChatId) {
        MeetingPolicyUpdatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingPolicyUpdatedEventMessageDetail");
        _x.meetingChatId = meetingChatId;
        return _x;
    }

    public MeetingPolicyUpdatedEventMessageDetail withUnmappedField(String name, Object value) {
        MeetingPolicyUpdatedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingPolicyUpdatedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet initiator;
        private Boolean meetingChatEnabled;
        private String meetingChatId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder meetingChatEnabled(Boolean meetingChatEnabled) {
            this.meetingChatEnabled = meetingChatEnabled;
            this.changedFields = changedFields.add("meetingChatEnabled");
            return this;
        }

        public Builder meetingChatId(String meetingChatId) {
            this.meetingChatId = meetingChatId;
            this.changedFields = changedFields.add("meetingChatId");
            return this;
        }

        public MeetingPolicyUpdatedEventMessageDetail build() {
            MeetingPolicyUpdatedEventMessageDetail _x = new MeetingPolicyUpdatedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingPolicyUpdatedEventMessageDetail";
            _x.initiator = initiator;
            _x.meetingChatEnabled = meetingChatEnabled;
            _x.meetingChatId = meetingChatId;
            return _x;
        }
    }

    private MeetingPolicyUpdatedEventMessageDetail _copy() {
        MeetingPolicyUpdatedEventMessageDetail _x = new MeetingPolicyUpdatedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiator = initiator;
        _x.meetingChatEnabled = meetingChatEnabled;
        _x.meetingChatId = meetingChatId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingPolicyUpdatedEventMessageDetail[");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("meetingChatEnabled=");
        b.append(this.meetingChatEnabled);
        b.append(", ");
        b.append("meetingChatId=");
        b.append(this.meetingChatId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
