package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "loop", 
    "mediaInfo"})
@JsonInclude(Include.NON_NULL)
public class MediaPrompt extends Prompt implements ODataType {

    @JsonProperty("loop")
    protected Integer loop;

    @JsonProperty("mediaInfo")
    protected MediaInfo mediaInfo;

    protected MediaPrompt() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaPrompt";
    }

    @Property(name="loop")
    @JsonIgnore
    public Optional<Integer> getLoop() {
        return Optional.ofNullable(loop);
    }

    public MediaPrompt withLoop(Integer loop) {
        MediaPrompt _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaPrompt");
        _x.loop = loop;
        return _x;
    }

    @Property(name="mediaInfo")
    @JsonIgnore
    public Optional<MediaInfo> getMediaInfo() {
        return Optional.ofNullable(mediaInfo);
    }

    public MediaPrompt withMediaInfo(MediaInfo mediaInfo) {
        MediaPrompt _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaPrompt");
        _x.mediaInfo = mediaInfo;
        return _x;
    }

    public MediaPrompt withUnmappedField(String name, Object value) {
        MediaPrompt _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMediaPrompt() {
        return new Builder();
    }

    public static final class Builder {
        private Integer loop;
        private MediaInfo mediaInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            this.changedFields = changedFields.add("loop");
            return this;
        }

        public Builder mediaInfo(MediaInfo mediaInfo) {
            this.mediaInfo = mediaInfo;
            this.changedFields = changedFields.add("mediaInfo");
            return this;
        }

        public MediaPrompt build() {
            MediaPrompt _x = new MediaPrompt();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mediaPrompt";
            _x.loop = loop;
            _x.mediaInfo = mediaInfo;
            return _x;
        }
    }

    private MediaPrompt _copy() {
        MediaPrompt _x = new MediaPrompt();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.loop = loop;
        _x.mediaInfo = mediaInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaPrompt[");
        b.append("loop=");
        b.append(this.loop);
        b.append(", ");
        b.append("mediaInfo=");
        b.append(this.mediaInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
