package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isTranscriptionShown", 
    "mediaSource"})
@JsonInclude(Include.NON_NULL)
public class Media implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isTranscriptionShown")
    protected Boolean isTranscriptionShown;

    @JsonProperty("mediaSource")
    protected MediaSource mediaSource;

    protected Media() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.media";
    }

    @Property(name="isTranscriptionShown")
    @JsonIgnore
    public Optional<Boolean> getIsTranscriptionShown() {
        return Optional.ofNullable(isTranscriptionShown);
    }

    public Media withIsTranscriptionShown(Boolean isTranscriptionShown) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.media");
        _x.isTranscriptionShown = isTranscriptionShown;
        return _x;
    }

    @Property(name="mediaSource")
    @JsonIgnore
    public Optional<MediaSource> getMediaSource() {
        return Optional.ofNullable(mediaSource);
    }

    public Media withMediaSource(MediaSource mediaSource) {
        Media _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.media");
        _x.mediaSource = mediaSource;
        return _x;
    }

    public Media withUnmappedField(String name, Object value) {
        Media _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isTranscriptionShown;
        private MediaSource mediaSource;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isTranscriptionShown(Boolean isTranscriptionShown) {
            this.isTranscriptionShown = isTranscriptionShown;
            this.changedFields = changedFields.add("isTranscriptionShown");
            return this;
        }

        public Builder mediaSource(MediaSource mediaSource) {
            this.mediaSource = mediaSource;
            this.changedFields = changedFields.add("mediaSource");
            return this;
        }

        public Media build() {
            Media _x = new Media();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.media";
            _x.isTranscriptionShown = isTranscriptionShown;
            _x.mediaSource = mediaSource;
            return _x;
        }
    }

    private Media _copy() {
        Media _x = new Media();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isTranscriptionShown = isTranscriptionShown;
        _x.mediaSource = mediaSource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Media[");
        b.append("isTranscriptionShown=");
        b.append(this.isTranscriptionShown);
        b.append(", ");
        b.append("mediaSource=");
        b.append(this.mediaSource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
