package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ApplicationMode;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationMode", 
    "description", 
    "displayName", 
    "id", 
    "isEndpointProtectionEnabled", 
    "labelActions", 
    "name", 
    "policyTip", 
    "priority", 
    "toolTip"})
@JsonInclude(Include.NON_NULL)
public class MatchingLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationMode")
    protected ApplicationMode applicationMode;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isEndpointProtectionEnabled")
    protected Boolean isEndpointProtectionEnabled;

    @JsonProperty("labelActions")
    protected List<LabelActionBase> labelActions;

    @JsonProperty("labelActions@nextLink")
    protected String labelActionsNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("policyTip")
    protected String policyTip;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("toolTip")
    protected String toolTip;

    protected MatchingLabel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.matchingLabel";
    }

    @Property(name="applicationMode")
    @JsonIgnore
    public Optional<ApplicationMode> getApplicationMode() {
        return Optional.ofNullable(applicationMode);
    }

    public MatchingLabel withApplicationMode(ApplicationMode applicationMode) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.applicationMode = applicationMode;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public MatchingLabel withDescription(String description) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MatchingLabel withDisplayName(String displayName) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public MatchingLabel withId(String id) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.id = id;
        return _x;
    }

    @Property(name="isEndpointProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEndpointProtectionEnabled() {
        return Optional.ofNullable(isEndpointProtectionEnabled);
    }

    public MatchingLabel withIsEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        return _x;
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions() {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, this.labelActions, Optional.ofNullable(labelActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions(HttpRequestOptions options) {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, this.labelActions, Optional.ofNullable(labelActionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public MatchingLabel withName(String name) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.name = name;
        return _x;
    }

    @Property(name="policyTip")
    @JsonIgnore
    public Optional<String> getPolicyTip() {
        return Optional.ofNullable(policyTip);
    }

    public MatchingLabel withPolicyTip(String policyTip) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.policyTip = policyTip;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public MatchingLabel withPriority(Integer priority) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.priority = priority;
        return _x;
    }

    @Property(name="toolTip")
    @JsonIgnore
    public Optional<String> getToolTip() {
        return Optional.ofNullable(toolTip);
    }

    public MatchingLabel withToolTip(String toolTip) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.toolTip = toolTip;
        return _x;
    }

    public MatchingLabel withUnmappedField(String name, Object value) {
        MatchingLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ApplicationMode applicationMode;
        private String description;
        private String displayName;
        private String id;
        private Boolean isEndpointProtectionEnabled;
        private List<LabelActionBase> labelActions;
        private String labelActionsNextLink;
        private String name;
        private String policyTip;
        private Integer priority;
        private String toolTip;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode = applicationMode;
            this.changedFields = changedFields.add("applicationMode");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
            this.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            this.changedFields = changedFields.add("isEndpointProtectionEnabled");
            return this;
        }

        public Builder labelActions(List<LabelActionBase> labelActions) {
            this.labelActions = labelActions;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder labelActions(LabelActionBase... labelActions) {
            return labelActions(Arrays.asList(labelActions));
        }

        public Builder labelActionsNextLink(String labelActionsNextLink) {
            this.labelActionsNextLink = labelActionsNextLink;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder policyTip(String policyTip) {
            this.policyTip = policyTip;
            this.changedFields = changedFields.add("policyTip");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder toolTip(String toolTip) {
            this.toolTip = toolTip;
            this.changedFields = changedFields.add("toolTip");
            return this;
        }

        public MatchingLabel build() {
            MatchingLabel _x = new MatchingLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.matchingLabel";
            _x.applicationMode = applicationMode;
            _x.description = description;
            _x.displayName = displayName;
            _x.id = id;
            _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            _x.labelActions = labelActions;
            _x.labelActionsNextLink = labelActionsNextLink;
            _x.name = name;
            _x.policyTip = policyTip;
            _x.priority = priority;
            _x.toolTip = toolTip;
            return _x;
        }
    }

    private MatchingLabel _copy() {
        MatchingLabel _x = new MatchingLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationMode = applicationMode;
        _x.description = description;
        _x.displayName = displayName;
        _x.id = id;
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        _x.labelActions = labelActions;
        _x.name = name;
        _x.policyTip = policyTip;
        _x.priority = priority;
        _x.toolTip = toolTip;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MatchingLabel[");
        b.append("applicationMode=");
        b.append(this.applicationMode);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEndpointProtectionEnabled=");
        b.append(this.isEndpointProtectionEnabled);
        b.append(", ");
        b.append("labelActions=");
        b.append(this.labelActions);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("policyTip=");
        b.append(this.policyTip);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("toolTip=");
        b.append(this.toolTip);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
