package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceManufacturers", 
    "deviceModels"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceModelsAndManufacturers implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceManufacturers")
    protected List<String> deviceManufacturers;

    @JsonProperty("deviceManufacturers@nextLink")
    protected String deviceManufacturersNextLink;

    @JsonProperty("deviceModels")
    protected List<String> deviceModels;

    @JsonProperty("deviceModels@nextLink")
    protected String deviceModelsNextLink;

    protected ManagedDeviceModelsAndManufacturers() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceModelsAndManufacturers";
    }

    /**
     * <i>“List of Manufactures for managed devices in the account”</i>
     * 
     * @return property deviceManufacturers
     */
    @Property(name="deviceManufacturers")
    @JsonIgnore
    public CollectionPage<String> getDeviceManufacturers() {
        return new CollectionPage<String>(contextPath, String.class, this.deviceManufacturers, Optional.ofNullable(deviceManufacturersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Manufactures for managed devices in the account”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property deviceManufacturers
     */
    @Property(name="deviceManufacturers")
    @JsonIgnore
    public CollectionPage<String> getDeviceManufacturers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.deviceManufacturers, Optional.ofNullable(deviceManufacturersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of Models for managed devices in the account”</i>
     * 
     * @return property deviceModels
     */
    @Property(name="deviceModels")
    @JsonIgnore
    public CollectionPage<String> getDeviceModels() {
        return new CollectionPage<String>(contextPath, String.class, this.deviceModels, Optional.ofNullable(deviceModelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Models for managed devices in the account”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property deviceModels
     */
    @Property(name="deviceModels")
    @JsonIgnore
    public CollectionPage<String> getDeviceModels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.deviceModels, Optional.ofNullable(deviceModelsNextLink), Collections.emptyList(), options);
    }

    public ManagedDeviceModelsAndManufacturers withUnmappedField(String name, Object value) {
        ManagedDeviceModelsAndManufacturers _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> deviceManufacturers;
        private String deviceManufacturersNextLink;
        private List<String> deviceModels;
        private String deviceModelsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturers
         *            value of {@code deviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturers(List<String> deviceManufacturers) {
            this.deviceManufacturers = deviceManufacturers;
            this.changedFields = changedFields.add("deviceManufacturers");
            return this;
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturers
         *            value of {@code deviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturers(String... deviceManufacturers) {
            return deviceManufacturers(Arrays.asList(deviceManufacturers));
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturersNextLink
         *            value of {@code deviceManufacturers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturersNextLink(String deviceManufacturersNextLink) {
            this.deviceManufacturersNextLink = deviceManufacturersNextLink;
            this.changedFields = changedFields.add("deviceManufacturers");
            return this;
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModels
         *            value of {@code deviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModels(List<String> deviceModels) {
            this.deviceModels = deviceModels;
            this.changedFields = changedFields.add("deviceModels");
            return this;
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModels
         *            value of {@code deviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModels(String... deviceModels) {
            return deviceModels(Arrays.asList(deviceModels));
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModelsNextLink
         *            value of {@code deviceModels@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModelsNextLink(String deviceModelsNextLink) {
            this.deviceModelsNextLink = deviceModelsNextLink;
            this.changedFields = changedFields.add("deviceModels");
            return this;
        }

        public ManagedDeviceModelsAndManufacturers build() {
            ManagedDeviceModelsAndManufacturers _x = new ManagedDeviceModelsAndManufacturers();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedDeviceModelsAndManufacturers";
            _x.deviceManufacturers = deviceManufacturers;
            _x.deviceManufacturersNextLink = deviceManufacturersNextLink;
            _x.deviceModels = deviceModels;
            _x.deviceModelsNextLink = deviceModelsNextLink;
            return _x;
        }
    }

    private ManagedDeviceModelsAndManufacturers _copy() {
        ManagedDeviceModelsAndManufacturers _x = new ManagedDeviceModelsAndManufacturers();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceManufacturers = deviceManufacturers;
        _x.deviceModels = deviceModels;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceModelsAndManufacturers[");
        b.append("deviceManufacturers=");
        b.append(this.deviceManufacturers);
        b.append(", ");
        b.append("deviceModels=");
        b.append(this.deviceModels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
