package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "family", 
    "name", 
    "severity", 
    "wasRunning"})
@JsonInclude(Include.NON_NULL)
public class MalwareState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("family")
    protected String family;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("severity")
    protected String severity;

    @JsonProperty("wasRunning")
    protected Boolean wasRunning;

    protected MalwareState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.malwareState";
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public MalwareState withCategory(String category) {
        MalwareState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareState");
        _x.category = category;
        return _x;
    }

    @Property(name="family")
    @JsonIgnore
    public Optional<String> getFamily() {
        return Optional.ofNullable(family);
    }

    public MalwareState withFamily(String family) {
        MalwareState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareState");
        _x.family = family;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public MalwareState withName(String name) {
        MalwareState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareState");
        _x.name = name;
        return _x;
    }

    @Property(name="severity")
    @JsonIgnore
    public Optional<String> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public MalwareState withSeverity(String severity) {
        MalwareState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareState");
        _x.severity = severity;
        return _x;
    }

    @Property(name="wasRunning")
    @JsonIgnore
    public Optional<Boolean> getWasRunning() {
        return Optional.ofNullable(wasRunning);
    }

    public MalwareState withWasRunning(Boolean wasRunning) {
        MalwareState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareState");
        _x.wasRunning = wasRunning;
        return _x;
    }

    public MalwareState withUnmappedField(String name, Object value) {
        MalwareState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String category;
        private String family;
        private String name;
        private String severity;
        private Boolean wasRunning;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder family(String family) {
            this.family = family;
            this.changedFields = changedFields.add("family");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public Builder wasRunning(Boolean wasRunning) {
            this.wasRunning = wasRunning;
            this.changedFields = changedFields.add("wasRunning");
            return this;
        }

        public MalwareState build() {
            MalwareState _x = new MalwareState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.malwareState";
            _x.category = category;
            _x.family = family;
            _x.name = name;
            _x.severity = severity;
            _x.wasRunning = wasRunning;
            return _x;
        }
    }

    private MalwareState _copy() {
        MalwareState _x = new MalwareState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.category = category;
        _x.family = family;
        _x.name = name;
        _x.severity = severity;
        _x.wasRunning = wasRunning;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MalwareState[");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("family=");
        b.append(this.family);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("wasRunning=");
        b.append(this.wasRunning);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
