package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RecipientScopeType;

@JsonPropertyOrder({
    "@odata.type", 
    "automaticReplies", 
    "customMailTip", 
    "deliveryRestricted", 
    "emailAddress", 
    "error", 
    "externalMemberCount", 
    "isModerated", 
    "mailboxFull", 
    "maxMessageSize", 
    "recipientScope", 
    "recipientSuggestions", 
    "totalMemberCount"})
@JsonInclude(Include.NON_NULL)
public class MailTips implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("automaticReplies")
    protected AutomaticRepliesMailTips automaticReplies;

    @JsonProperty("customMailTip")
    protected String customMailTip;

    @JsonProperty("deliveryRestricted")
    protected Boolean deliveryRestricted;

    @JsonProperty("emailAddress")
    protected EmailAddress emailAddress;

    @JsonProperty("error")
    protected MailTipsError error;

    @JsonProperty("externalMemberCount")
    protected Integer externalMemberCount;

    @JsonProperty("isModerated")
    protected Boolean isModerated;

    @JsonProperty("mailboxFull")
    protected Boolean mailboxFull;

    @JsonProperty("maxMessageSize")
    protected Integer maxMessageSize;

    @JsonProperty("recipientScope")
    protected RecipientScopeType recipientScope;

    @JsonProperty("recipientSuggestions")
    protected List<Recipient> recipientSuggestions;

    @JsonProperty("recipientSuggestions@nextLink")
    protected String recipientSuggestionsNextLink;

    @JsonProperty("totalMemberCount")
    protected Integer totalMemberCount;

    protected MailTips() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailTips";
    }

    @Property(name="automaticReplies")
    @JsonIgnore
    public Optional<AutomaticRepliesMailTips> getAutomaticReplies() {
        return Optional.ofNullable(automaticReplies);
    }

    public MailTips withAutomaticReplies(AutomaticRepliesMailTips automaticReplies) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.automaticReplies = automaticReplies;
        return _x;
    }

    @Property(name="customMailTip")
    @JsonIgnore
    public Optional<String> getCustomMailTip() {
        return Optional.ofNullable(customMailTip);
    }

    public MailTips withCustomMailTip(String customMailTip) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.customMailTip = customMailTip;
        return _x;
    }

    @Property(name="deliveryRestricted")
    @JsonIgnore
    public Optional<Boolean> getDeliveryRestricted() {
        return Optional.ofNullable(deliveryRestricted);
    }

    public MailTips withDeliveryRestricted(Boolean deliveryRestricted) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.deliveryRestricted = deliveryRestricted;
        return _x;
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<EmailAddress> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public MailTips withEmailAddress(EmailAddress emailAddress) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<MailTipsError> getError() {
        return Optional.ofNullable(error);
    }

    public MailTips withError(MailTipsError error) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.error = error;
        return _x;
    }

    @Property(name="externalMemberCount")
    @JsonIgnore
    public Optional<Integer> getExternalMemberCount() {
        return Optional.ofNullable(externalMemberCount);
    }

    public MailTips withExternalMemberCount(Integer externalMemberCount) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.externalMemberCount = externalMemberCount;
        return _x;
    }

    @Property(name="isModerated")
    @JsonIgnore
    public Optional<Boolean> getIsModerated() {
        return Optional.ofNullable(isModerated);
    }

    public MailTips withIsModerated(Boolean isModerated) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.isModerated = isModerated;
        return _x;
    }

    @Property(name="mailboxFull")
    @JsonIgnore
    public Optional<Boolean> getMailboxFull() {
        return Optional.ofNullable(mailboxFull);
    }

    public MailTips withMailboxFull(Boolean mailboxFull) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.mailboxFull = mailboxFull;
        return _x;
    }

    @Property(name="maxMessageSize")
    @JsonIgnore
    public Optional<Integer> getMaxMessageSize() {
        return Optional.ofNullable(maxMessageSize);
    }

    public MailTips withMaxMessageSize(Integer maxMessageSize) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.maxMessageSize = maxMessageSize;
        return _x;
    }

    @Property(name="recipientScope")
    @JsonIgnore
    public Optional<RecipientScopeType> getRecipientScope() {
        return Optional.ofNullable(recipientScope);
    }

    public MailTips withRecipientScope(RecipientScopeType recipientScope) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.recipientScope = recipientScope;
        return _x;
    }

    @Property(name="recipientSuggestions")
    @JsonIgnore
    public CollectionPage<Recipient> getRecipientSuggestions() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, this.recipientSuggestions, Optional.ofNullable(recipientSuggestionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recipientSuggestions")
    @JsonIgnore
    public CollectionPage<Recipient> getRecipientSuggestions(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, this.recipientSuggestions, Optional.ofNullable(recipientSuggestionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="totalMemberCount")
    @JsonIgnore
    public Optional<Integer> getTotalMemberCount() {
        return Optional.ofNullable(totalMemberCount);
    }

    public MailTips withTotalMemberCount(Integer totalMemberCount) {
        MailTips _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailTips");
        _x.totalMemberCount = totalMemberCount;
        return _x;
    }

    public MailTips withUnmappedField(String name, Object value) {
        MailTips _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AutomaticRepliesMailTips automaticReplies;
        private String customMailTip;
        private Boolean deliveryRestricted;
        private EmailAddress emailAddress;
        private MailTipsError error;
        private Integer externalMemberCount;
        private Boolean isModerated;
        private Boolean mailboxFull;
        private Integer maxMessageSize;
        private RecipientScopeType recipientScope;
        private List<Recipient> recipientSuggestions;
        private String recipientSuggestionsNextLink;
        private Integer totalMemberCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder automaticReplies(AutomaticRepliesMailTips automaticReplies) {
            this.automaticReplies = automaticReplies;
            this.changedFields = changedFields.add("automaticReplies");
            return this;
        }

        public Builder customMailTip(String customMailTip) {
            this.customMailTip = customMailTip;
            this.changedFields = changedFields.add("customMailTip");
            return this;
        }

        public Builder deliveryRestricted(Boolean deliveryRestricted) {
            this.deliveryRestricted = deliveryRestricted;
            this.changedFields = changedFields.add("deliveryRestricted");
            return this;
        }

        public Builder emailAddress(EmailAddress emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder error(MailTipsError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder externalMemberCount(Integer externalMemberCount) {
            this.externalMemberCount = externalMemberCount;
            this.changedFields = changedFields.add("externalMemberCount");
            return this;
        }

        public Builder isModerated(Boolean isModerated) {
            this.isModerated = isModerated;
            this.changedFields = changedFields.add("isModerated");
            return this;
        }

        public Builder mailboxFull(Boolean mailboxFull) {
            this.mailboxFull = mailboxFull;
            this.changedFields = changedFields.add("mailboxFull");
            return this;
        }

        public Builder maxMessageSize(Integer maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            this.changedFields = changedFields.add("maxMessageSize");
            return this;
        }

        public Builder recipientScope(RecipientScopeType recipientScope) {
            this.recipientScope = recipientScope;
            this.changedFields = changedFields.add("recipientScope");
            return this;
        }

        public Builder recipientSuggestions(List<Recipient> recipientSuggestions) {
            this.recipientSuggestions = recipientSuggestions;
            this.changedFields = changedFields.add("recipientSuggestions");
            return this;
        }

        public Builder recipientSuggestions(Recipient... recipientSuggestions) {
            return recipientSuggestions(Arrays.asList(recipientSuggestions));
        }

        public Builder recipientSuggestionsNextLink(String recipientSuggestionsNextLink) {
            this.recipientSuggestionsNextLink = recipientSuggestionsNextLink;
            this.changedFields = changedFields.add("recipientSuggestions");
            return this;
        }

        public Builder totalMemberCount(Integer totalMemberCount) {
            this.totalMemberCount = totalMemberCount;
            this.changedFields = changedFields.add("totalMemberCount");
            return this;
        }

        public MailTips build() {
            MailTips _x = new MailTips();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mailTips";
            _x.automaticReplies = automaticReplies;
            _x.customMailTip = customMailTip;
            _x.deliveryRestricted = deliveryRestricted;
            _x.emailAddress = emailAddress;
            _x.error = error;
            _x.externalMemberCount = externalMemberCount;
            _x.isModerated = isModerated;
            _x.mailboxFull = mailboxFull;
            _x.maxMessageSize = maxMessageSize;
            _x.recipientScope = recipientScope;
            _x.recipientSuggestions = recipientSuggestions;
            _x.recipientSuggestionsNextLink = recipientSuggestionsNextLink;
            _x.totalMemberCount = totalMemberCount;
            return _x;
        }
    }

    private MailTips _copy() {
        MailTips _x = new MailTips();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.automaticReplies = automaticReplies;
        _x.customMailTip = customMailTip;
        _x.deliveryRestricted = deliveryRestricted;
        _x.emailAddress = emailAddress;
        _x.error = error;
        _x.externalMemberCount = externalMemberCount;
        _x.isModerated = isModerated;
        _x.mailboxFull = mailboxFull;
        _x.maxMessageSize = maxMessageSize;
        _x.recipientScope = recipientScope;
        _x.recipientSuggestions = recipientSuggestions;
        _x.totalMemberCount = totalMemberCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailTips[");
        b.append("automaticReplies=");
        b.append(this.automaticReplies);
        b.append(", ");
        b.append("customMailTip=");
        b.append(this.customMailTip);
        b.append(", ");
        b.append("deliveryRestricted=");
        b.append(this.deliveryRestricted);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("externalMemberCount=");
        b.append(this.externalMemberCount);
        b.append(", ");
        b.append("isModerated=");
        b.append(this.isModerated);
        b.append(", ");
        b.append("mailboxFull=");
        b.append(this.mailboxFull);
        b.append(", ");
        b.append("maxMessageSize=");
        b.append(this.maxMessageSize);
        b.append(", ");
        b.append("recipientScope=");
        b.append(this.recipientScope);
        b.append(", ");
        b.append("recipientSuggestions=");
        b.append(this.recipientSuggestions);
        b.append(", ");
        b.append("totalMemberCount=");
        b.append(this.totalMemberCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
