package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties used to assign an Mac VPP mobile app to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "uninstallOnDeviceRemoval", 
    "useDeviceLicensing"})
@JsonInclude(Include.NON_NULL)
public class MacOsVppAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JsonProperty("uninstallOnDeviceRemoval")
    protected Boolean uninstallOnDeviceRemoval;

    @JsonProperty("useDeviceLicensing")
    protected Boolean useDeviceLicensing;

    protected MacOsVppAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOsVppAppAssignmentSettings";
    }

    /**
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @return property uninstallOnDeviceRemoval
     */
    @Property(name="uninstallOnDeviceRemoval")
    @JsonIgnore
    public Optional<Boolean> getUninstallOnDeviceRemoval() {
        return Optional.ofNullable(uninstallOnDeviceRemoval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * uninstallOnDeviceRemoval} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @param uninstallOnDeviceRemoval
     *            new value of {@code uninstallOnDeviceRemoval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uninstallOnDeviceRemoval} field changed
     */
    public MacOsVppAppAssignmentSettings withUninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
        MacOsVppAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppAppAssignmentSettings");
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        return _x;
    }

    /**
     * <i>“Whether or not to use device licensing.”</i>
     * 
     * @return property useDeviceLicensing
     */
    @Property(name="useDeviceLicensing")
    @JsonIgnore
    public Optional<Boolean> getUseDeviceLicensing() {
        return Optional.ofNullable(useDeviceLicensing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useDeviceLicensing} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether or not to use device licensing.”</i>
     * 
     * @param useDeviceLicensing
     *            new value of {@code useDeviceLicensing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useDeviceLicensing} field changed
     */
    public MacOsVppAppAssignmentSettings withUseDeviceLicensing(Boolean useDeviceLicensing) {
        MacOsVppAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppAppAssignmentSettings");
        _x.useDeviceLicensing = useDeviceLicensing;
        return _x;
    }

    public MacOsVppAppAssignmentSettings withUnmappedField(String name, Object value) {
        MacOsVppAppAssignmentSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOsVppAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean uninstallOnDeviceRemoval;
        private Boolean useDeviceLicensing;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
         * 
         * @param uninstallOnDeviceRemoval
         *            value of {@code uninstallOnDeviceRemoval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
            this.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            this.changedFields = changedFields.add("uninstallOnDeviceRemoval");
            return this;
        }

        /**
         * <i>“Whether or not to use device licensing.”</i>
         * 
         * @param useDeviceLicensing
         *            value of {@code useDeviceLicensing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useDeviceLicensing(Boolean useDeviceLicensing) {
            this.useDeviceLicensing = useDeviceLicensing;
            this.changedFields = changedFields.add("useDeviceLicensing");
            return this;
        }

        public MacOsVppAppAssignmentSettings build() {
            MacOsVppAppAssignmentSettings _x = new MacOsVppAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOsVppAppAssignmentSettings";
            _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            _x.useDeviceLicensing = useDeviceLicensing;
            return _x;
        }
    }

    private MacOsVppAppAssignmentSettings _copy() {
        MacOsVppAppAssignmentSettings _x = new MacOsVppAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        _x.useDeviceLicensing = useDeviceLicensing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOsVppAppAssignmentSettings[");
        b.append("uninstallOnDeviceRemoval=");
        b.append(this.uninstallOnDeviceRemoval);
        b.append(", ");
        b.append("useDeviceLicensing=");
        b.append(this.useDeviceLicensing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
