package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MacOSSystemExtensionType;


/**
 * <i>“Represents a mapping between team identifiers for macOS system extensions and
 * system extension types.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedTypes", 
    "teamIdentifier"})
@JsonInclude(Include.NON_NULL)
public class MacOSSystemExtensionTypeMapping implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedTypes")
    protected MacOSSystemExtensionType allowedTypes;

    @JsonProperty("teamIdentifier")
    protected String teamIdentifier;

    protected MacOSSystemExtensionTypeMapping() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSSystemExtensionTypeMapping";
    }

    /**
     * <i>“Gets or sets the allowed macOS system extension types.”</i>
     * 
     * @return property allowedTypes
     */
    @Property(name="allowedTypes")
    @JsonIgnore
    public Optional<MacOSSystemExtensionType> getAllowedTypes() {
        return Optional.ofNullable(allowedTypes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code allowedTypes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the allowed macOS system extension types.”</i>
     * 
     * @param allowedTypes
     *            new value of {@code allowedTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedTypes} field changed
     */
    public MacOSSystemExtensionTypeMapping withAllowedTypes(MacOSSystemExtensionType allowedTypes) {
        MacOSSystemExtensionTypeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSystemExtensionTypeMapping");
        _x.allowedTypes = allowedTypes;
        return _x;
    }

    /**
     * <i>“Gets or sets the team identifier used to sign the system extension.”</i>
     * 
     * @return property teamIdentifier
     */
    @Property(name="teamIdentifier")
    @JsonIgnore
    public Optional<String> getTeamIdentifier() {
        return Optional.ofNullable(teamIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teamIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the team identifier used to sign the system extension.”</i>
     * 
     * @param teamIdentifier
     *            new value of {@code teamIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teamIdentifier} field changed
     */
    public MacOSSystemExtensionTypeMapping withTeamIdentifier(String teamIdentifier) {
        MacOSSystemExtensionTypeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSystemExtensionTypeMapping");
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    public MacOSSystemExtensionTypeMapping withUnmappedField(String name, Object value) {
        MacOSSystemExtensionTypeMapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MacOSSystemExtensionType allowedTypes;
        private String teamIdentifier;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Gets or sets the allowed macOS system extension types.”</i>
         * 
         * @param allowedTypes
         *            value of {@code allowedTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedTypes(MacOSSystemExtensionType allowedTypes) {
            this.allowedTypes = allowedTypes;
            this.changedFields = changedFields.add("allowedTypes");
            return this;
        }

        /**
         * <i>“Gets or sets the team identifier used to sign the system extension.”</i>
         * 
         * @param teamIdentifier
         *            value of {@code teamIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teamIdentifier(String teamIdentifier) {
            this.teamIdentifier = teamIdentifier;
            this.changedFields = changedFields.add("teamIdentifier");
            return this;
        }

        public MacOSSystemExtensionTypeMapping build() {
            MacOSSystemExtensionTypeMapping _x = new MacOSSystemExtensionTypeMapping();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSSystemExtensionTypeMapping";
            _x.allowedTypes = allowedTypes;
            _x.teamIdentifier = teamIdentifier;
            return _x;
        }
    }

    private MacOSSystemExtensionTypeMapping _copy() {
        MacOSSystemExtensionTypeMapping _x = new MacOSSystemExtensionTypeMapping();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedTypes = allowedTypes;
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSSystemExtensionTypeMapping[");
        b.append("allowedTypes=");
        b.append(this.allowedTypes);
        b.append(", ");
        b.append("teamIdentifier=");
        b.append(this.teamIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
