package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A mapping of application identifiers to associated domains.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationIdentifier", 
    "directDownloadsEnabled", 
    "domains"})
@JsonInclude(Include.NON_NULL)
public class MacOSAssociatedDomainsItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationIdentifier")
    protected String applicationIdentifier;

    @JsonProperty("directDownloadsEnabled")
    protected Boolean directDownloadsEnabled;

    @JsonProperty("domains")
    protected List<String> domains;

    @JsonProperty("domains@nextLink")
    protected String domainsNextLink;

    protected MacOSAssociatedDomainsItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSAssociatedDomainsItem";
    }

    /**
     * <i>“The application identifier of the app to associate domains with.”</i>
     * 
     * @return property applicationIdentifier
     */
    @Property(name="applicationIdentifier")
    @JsonIgnore
    public Optional<String> getApplicationIdentifier() {
        return Optional.ofNullable(applicationIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The application identifier of the app to associate domains with.”</i>
     * 
     * @param applicationIdentifier
     *            new value of {@code applicationIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationIdentifier} field changed
     */
    public MacOSAssociatedDomainsItem withApplicationIdentifier(String applicationIdentifier) {
        MacOSAssociatedDomainsItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAssociatedDomainsItem");
        _x.applicationIdentifier = applicationIdentifier;
        return _x;
    }

    /**
     * <i>“Determines whether data should be downloaded directly or via a CDN.”</i>
     * 
     * @return property directDownloadsEnabled
     */
    @Property(name="directDownloadsEnabled")
    @JsonIgnore
    public Optional<Boolean> getDirectDownloadsEnabled() {
        return Optional.ofNullable(directDownloadsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * directDownloadsEnabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines whether data should be downloaded directly or via a CDN.”</i>
     * 
     * @param directDownloadsEnabled
     *            new value of {@code directDownloadsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code directDownloadsEnabled} field changed
     */
    public MacOSAssociatedDomainsItem withDirectDownloadsEnabled(Boolean directDownloadsEnabled) {
        MacOSAssociatedDomainsItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAssociatedDomainsItem");
        _x.directDownloadsEnabled = directDownloadsEnabled;
        return _x;
    }

    /**
     * <i>“The list of domains to associate.”</i>
     * 
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains() {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The list of domains to associate.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), options);
    }

    public MacOSAssociatedDomainsItem withUnmappedField(String name, Object value) {
        MacOSAssociatedDomainsItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationIdentifier;
        private Boolean directDownloadsEnabled;
        private List<String> domains;
        private String domainsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The application identifier of the app to associate domains with.”</i>
         * 
         * @param applicationIdentifier
         *            value of {@code applicationIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            this.changedFields = changedFields.add("applicationIdentifier");
            return this;
        }

        /**
         * <i>“Determines whether data should be downloaded directly or via a CDN.”</i>
         * 
         * @param directDownloadsEnabled
         *            value of {@code directDownloadsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder directDownloadsEnabled(Boolean directDownloadsEnabled) {
            this.directDownloadsEnabled = directDownloadsEnabled;
            this.changedFields = changedFields.add("directDownloadsEnabled");
            return this;
        }

        /**
         * <i>“The list of domains to associate.”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(List<String> domains) {
            this.domains = domains;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        /**
         * <i>“The list of domains to associate.”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(String... domains) {
            return domains(Arrays.asList(domains));
        }

        /**
         * <i>“The list of domains to associate.”</i>
         * 
         * @param domainsNextLink
         *            value of {@code domains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainsNextLink(String domainsNextLink) {
            this.domainsNextLink = domainsNextLink;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        public MacOSAssociatedDomainsItem build() {
            MacOSAssociatedDomainsItem _x = new MacOSAssociatedDomainsItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSAssociatedDomainsItem";
            _x.applicationIdentifier = applicationIdentifier;
            _x.directDownloadsEnabled = directDownloadsEnabled;
            _x.domains = domains;
            _x.domainsNextLink = domainsNextLink;
            return _x;
        }
    }

    private MacOSAssociatedDomainsItem _copy() {
        MacOSAssociatedDomainsItem _x = new MacOSAssociatedDomainsItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationIdentifier = applicationIdentifier;
        _x.directDownloadsEnabled = directDownloadsEnabled;
        _x.domains = domains;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSAssociatedDomainsItem[");
        b.append("applicationIdentifier=");
        b.append(this.applicationIdentifier);
        b.append(", ");
        b.append("directDownloadsEnabled=");
        b.append(this.directDownloadsEnabled);
        b.append(", ");
        b.append("domains=");
        b.append(this.domains);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
