package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MacOSProcessIdentifierType;


/**
 * <i>“Represents a process that can receive an Apple Event notification.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowed", 
    "codeRequirement", 
    "identifier", 
    "identifierType"})
@JsonInclude(Include.NON_NULL)
public class MacOSAppleEventReceiver implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowed")
    protected Boolean allowed;

    @JsonProperty("codeRequirement")
    protected String codeRequirement;

    @JsonProperty("identifier")
    protected String identifier;

    @JsonProperty("identifierType")
    protected MacOSProcessIdentifierType identifierType;

    protected MacOSAppleEventReceiver() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSAppleEventReceiver";
    }

    /**
     * <i>“Allow or block this app from receiving Apple events.”</i>
     * 
     * @return property allowed
     */
    @Property(name="allowed")
    @JsonIgnore
    public Optional<Boolean> getAllowed() {
        return Optional.ofNullable(allowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code allowed} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow or block this app from receiving Apple events.”</i>
     * 
     * @param allowed
     *            new value of {@code allowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowed} field changed
     */
    public MacOSAppleEventReceiver withAllowed(Boolean allowed) {
        MacOSAppleEventReceiver _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAppleEventReceiver");
        _x.allowed = allowed;
        return _x;
    }

    /**
     * <i>“Code requirement for the app or binary that receives the Apple Event.”</i>
     * 
     * @return property codeRequirement
     */
    @Property(name="codeRequirement")
    @JsonIgnore
    public Optional<String> getCodeRequirement() {
        return Optional.ofNullable(codeRequirement);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code codeRequirement}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Code requirement for the app or binary that receives the Apple Event.”</i>
     * 
     * @param codeRequirement
     *            new value of {@code codeRequirement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeRequirement} field changed
     */
    public MacOSAppleEventReceiver withCodeRequirement(String codeRequirement) {
        MacOSAppleEventReceiver _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAppleEventReceiver");
        _x.codeRequirement = codeRequirement;
        return _x;
    }

    /**
     * <i>“Bundle ID of the app or file path of the process or executable that receives the
     * Apple Event.”</i>
     * 
     * @return property identifier
     */
    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifier} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Bundle ID of the app or file path of the process or executable that receives the
     * Apple Event.”</i>
     * 
     * @param identifier
     *            new value of {@code identifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifier} field changed
     */
    public MacOSAppleEventReceiver withIdentifier(String identifier) {
        MacOSAppleEventReceiver _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAppleEventReceiver");
        _x.identifier = identifier;
        return _x;
    }

    /**
     * <i>“Use bundle ID for an app or path for a process or executable that receives the
     * Apple Event.”</i>
     * 
     * @return property identifierType
     */
    @Property(name="identifierType")
    @JsonIgnore
    public Optional<MacOSProcessIdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifierType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Use bundle ID for an app or path for a process or executable that receives the
     * Apple Event.”</i>
     * 
     * @param identifierType
     *            new value of {@code identifierType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifierType} field changed
     */
    public MacOSAppleEventReceiver withIdentifierType(MacOSProcessIdentifierType identifierType) {
        MacOSAppleEventReceiver _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSAppleEventReceiver");
        _x.identifierType = identifierType;
        return _x;
    }

    public MacOSAppleEventReceiver withUnmappedField(String name, Object value) {
        MacOSAppleEventReceiver _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowed;
        private String codeRequirement;
        private String identifier;
        private MacOSProcessIdentifierType identifierType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Allow or block this app from receiving Apple events.”</i>
         * 
         * @param allowed
         *            value of {@code allowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowed(Boolean allowed) {
            this.allowed = allowed;
            this.changedFields = changedFields.add("allowed");
            return this;
        }

        /**
         * <i>“Code requirement for the app or binary that receives the Apple Event.”</i>
         * 
         * @param codeRequirement
         *            value of {@code codeRequirement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeRequirement(String codeRequirement) {
            this.codeRequirement = codeRequirement;
            this.changedFields = changedFields.add("codeRequirement");
            return this;
        }

        /**
         * <i>“Bundle ID of the app or file path of the process or executable that receives the
         * Apple Event.”</i>
         * 
         * @param identifier
         *            value of {@code identifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        /**
         * <i>“Use bundle ID for an app or path for a process or executable that receives the
         * Apple Event.”</i>
         * 
         * @param identifierType
         *            value of {@code identifierType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identifierType(MacOSProcessIdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("identifierType");
            return this;
        }

        public MacOSAppleEventReceiver build() {
            MacOSAppleEventReceiver _x = new MacOSAppleEventReceiver();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSAppleEventReceiver";
            _x.allowed = allowed;
            _x.codeRequirement = codeRequirement;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            return _x;
        }
    }

    private MacOSAppleEventReceiver _copy() {
        MacOSAppleEventReceiver _x = new MacOSAppleEventReceiver();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowed = allowed;
        _x.codeRequirement = codeRequirement;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSAppleEventReceiver[");
        b.append("allowed=");
        b.append(this.allowed);
        b.append(", ");
        b.append("codeRequirement=");
        b.append(this.codeRequirement);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("identifierType=");
        b.append(this.identifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
