package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "logicAppWorkflowName", 
    "resourceGroupName", 
    "subscriptionId"})
@JsonInclude(Include.NON_NULL)
public class LogicAppTriggerEndpointConfiguration extends CustomExtensionEndpointConfiguration implements ODataType {

    @JsonProperty("logicAppWorkflowName")
    protected String logicAppWorkflowName;

    @JsonProperty("resourceGroupName")
    protected String resourceGroupName;

    @JsonProperty("subscriptionId")
    protected String subscriptionId;

    protected LogicAppTriggerEndpointConfiguration() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.logicAppTriggerEndpointConfiguration";
    }

    @Property(name="logicAppWorkflowName")
    @JsonIgnore
    public Optional<String> getLogicAppWorkflowName() {
        return Optional.ofNullable(logicAppWorkflowName);
    }

    public LogicAppTriggerEndpointConfiguration withLogicAppWorkflowName(String logicAppWorkflowName) {
        LogicAppTriggerEndpointConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logicAppTriggerEndpointConfiguration");
        _x.logicAppWorkflowName = logicAppWorkflowName;
        return _x;
    }

    @Property(name="resourceGroupName")
    @JsonIgnore
    public Optional<String> getResourceGroupName() {
        return Optional.ofNullable(resourceGroupName);
    }

    public LogicAppTriggerEndpointConfiguration withResourceGroupName(String resourceGroupName) {
        LogicAppTriggerEndpointConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logicAppTriggerEndpointConfiguration");
        _x.resourceGroupName = resourceGroupName;
        return _x;
    }

    @Property(name="subscriptionId")
    @JsonIgnore
    public Optional<String> getSubscriptionId() {
        return Optional.ofNullable(subscriptionId);
    }

    public LogicAppTriggerEndpointConfiguration withSubscriptionId(String subscriptionId) {
        LogicAppTriggerEndpointConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logicAppTriggerEndpointConfiguration");
        _x.subscriptionId = subscriptionId;
        return _x;
    }

    public LogicAppTriggerEndpointConfiguration withUnmappedField(String name, Object value) {
        LogicAppTriggerEndpointConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLogicAppTriggerEndpointConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String logicAppWorkflowName;
        private String resourceGroupName;
        private String subscriptionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder logicAppWorkflowName(String logicAppWorkflowName) {
            this.logicAppWorkflowName = logicAppWorkflowName;
            this.changedFields = changedFields.add("logicAppWorkflowName");
            return this;
        }

        public Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            this.changedFields = changedFields.add("resourceGroupName");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.changedFields = changedFields.add("subscriptionId");
            return this;
        }

        public LogicAppTriggerEndpointConfiguration build() {
            LogicAppTriggerEndpointConfiguration _x = new LogicAppTriggerEndpointConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.logicAppTriggerEndpointConfiguration";
            _x.logicAppWorkflowName = logicAppWorkflowName;
            _x.resourceGroupName = resourceGroupName;
            _x.subscriptionId = subscriptionId;
            return _x;
        }
    }

    private LogicAppTriggerEndpointConfiguration _copy() {
        LogicAppTriggerEndpointConfiguration _x = new LogicAppTriggerEndpointConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.logicAppWorkflowName = logicAppWorkflowName;
        _x.resourceGroupName = resourceGroupName;
        _x.subscriptionId = subscriptionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LogicAppTriggerEndpointConfiguration[");
        b.append("logicAppWorkflowName=");
        b.append(this.logicAppWorkflowName);
        b.append(", ");
        b.append("resourceGroupName=");
        b.append(this.resourceGroupName);
        b.append(", ");
        b.append("subscriptionId=");
        b.append(this.subscriptionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
