package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Logged On User”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastLogOnDateTime", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class LoggedOnUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastLogOnDateTime")
    protected OffsetDateTime lastLogOnDateTime;

    @JsonProperty("userId")
    protected String userId;

    protected LoggedOnUser() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.loggedOnUser";
    }

    /**
     * <i>“Date time when user logs on”</i>
     * 
     * @return property lastLogOnDateTime
     */
    @Property(name="lastLogOnDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastLogOnDateTime() {
        return Optional.ofNullable(lastLogOnDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastLogOnDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Date time when user logs on”</i>
     * 
     * @param lastLogOnDateTime
     *            new value of {@code lastLogOnDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastLogOnDateTime} field changed
     */
    public LoggedOnUser withLastLogOnDateTime(OffsetDateTime lastLogOnDateTime) {
        LoggedOnUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loggedOnUser");
        _x.lastLogOnDateTime = lastLogOnDateTime;
        return _x;
    }

    /**
     * <i>“User id”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User id”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public LoggedOnUser withUserId(String userId) {
        LoggedOnUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loggedOnUser");
        _x.userId = userId;
        return _x;
    }

    public LoggedOnUser withUnmappedField(String name, Object value) {
        LoggedOnUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastLogOnDateTime;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Date time when user logs on”</i>
         * 
         * @param lastLogOnDateTime
         *            value of {@code lastLogOnDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastLogOnDateTime(OffsetDateTime lastLogOnDateTime) {
            this.lastLogOnDateTime = lastLogOnDateTime;
            this.changedFields = changedFields.add("lastLogOnDateTime");
            return this;
        }

        /**
         * <i>“User id”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public LoggedOnUser build() {
            LoggedOnUser _x = new LoggedOnUser();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.loggedOnUser";
            _x.lastLogOnDateTime = lastLogOnDateTime;
            _x.userId = userId;
            return _x;
        }
    }

    private LoggedOnUser _copy() {
        LoggedOnUser _x = new LoggedOnUser();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastLogOnDateTime = lastLogOnDateTime;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LoggedOnUser[");
        b.append("lastLogOnDateTime=");
        b.append(this.lastLogOnDateTime);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
