package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isRequired", 
    "locations", 
    "suggestLocation"})
@JsonInclude(Include.NON_NULL)
public class LocationConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("locations")
    protected List<LocationConstraintItem> locations;

    @JsonProperty("locations@nextLink")
    protected String locationsNextLink;

    @JsonProperty("suggestLocation")
    protected Boolean suggestLocation;

    protected LocationConstraint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.locationConstraint";
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public LocationConstraint withIsRequired(Boolean isRequired) {
        LocationConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locationConstraint");
        _x.isRequired = isRequired;
        return _x;
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<LocationConstraintItem> getLocations() {
        return new CollectionPage<LocationConstraintItem>(contextPath, LocationConstraintItem.class, this.locations, Optional.ofNullable(locationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<LocationConstraintItem> getLocations(HttpRequestOptions options) {
        return new CollectionPage<LocationConstraintItem>(contextPath, LocationConstraintItem.class, this.locations, Optional.ofNullable(locationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="suggestLocation")
    @JsonIgnore
    public Optional<Boolean> getSuggestLocation() {
        return Optional.ofNullable(suggestLocation);
    }

    public LocationConstraint withSuggestLocation(Boolean suggestLocation) {
        LocationConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locationConstraint");
        _x.suggestLocation = suggestLocation;
        return _x;
    }

    public LocationConstraint withUnmappedField(String name, Object value) {
        LocationConstraint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private List<LocationConstraintItem> locations;
        private String locationsNextLink;
        private Boolean suggestLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder locations(List<LocationConstraintItem> locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder locations(LocationConstraintItem... locations) {
            return locations(Arrays.asList(locations));
        }

        public Builder locationsNextLink(String locationsNextLink) {
            this.locationsNextLink = locationsNextLink;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder suggestLocation(Boolean suggestLocation) {
            this.suggestLocation = suggestLocation;
            this.changedFields = changedFields.add("suggestLocation");
            return this;
        }

        public LocationConstraint build() {
            LocationConstraint _x = new LocationConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.locationConstraint";
            _x.isRequired = isRequired;
            _x.locations = locations;
            _x.locationsNextLink = locationsNextLink;
            _x.suggestLocation = suggestLocation;
            return _x;
        }
    }

    private LocationConstraint _copy() {
        LocationConstraint _x = new LocationConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.locations = locations;
        _x.suggestLocation = suggestLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocationConstraint[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("suggestLocation=");
        b.append(this.suggestLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
