package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.LocationType;
import odata.msgraph.client.beta.enums.LocationUniqueIdType;

@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "coordinates", 
    "displayName", 
    "locationEmailAddress", 
    "locationType", 
    "locationUri", 
    "uniqueId", 
    "uniqueIdType"})
@JsonInclude(Include.NON_NULL)
public class Location implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("address")
    protected PhysicalAddress address;

    @JsonProperty("coordinates")
    protected OutlookGeoCoordinates coordinates;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("locationEmailAddress")
    protected String locationEmailAddress;

    @JsonProperty("locationType")
    protected LocationType locationType;

    @JsonProperty("locationUri")
    protected String locationUri;

    @JsonProperty("uniqueId")
    protected String uniqueId;

    @JsonProperty("uniqueIdType")
    protected LocationUniqueIdType uniqueIdType;

    protected Location() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.location";
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PhysicalAddress> getAddress() {
        return Optional.ofNullable(address);
    }

    public Location withAddress(PhysicalAddress address) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.address = address;
        return _x;
    }

    @Property(name="coordinates")
    @JsonIgnore
    public Optional<OutlookGeoCoordinates> getCoordinates() {
        return Optional.ofNullable(coordinates);
    }

    public Location withCoordinates(OutlookGeoCoordinates coordinates) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.coordinates = coordinates;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Location withDisplayName(String displayName) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="locationEmailAddress")
    @JsonIgnore
    public Optional<String> getLocationEmailAddress() {
        return Optional.ofNullable(locationEmailAddress);
    }

    public Location withLocationEmailAddress(String locationEmailAddress) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.locationEmailAddress = locationEmailAddress;
        return _x;
    }

    @Property(name="locationType")
    @JsonIgnore
    public Optional<LocationType> getLocationType() {
        return Optional.ofNullable(locationType);
    }

    public Location withLocationType(LocationType locationType) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.locationType = locationType;
        return _x;
    }

    @Property(name="locationUri")
    @JsonIgnore
    public Optional<String> getLocationUri() {
        return Optional.ofNullable(locationUri);
    }

    public Location withLocationUri(String locationUri) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.locationUri = locationUri;
        return _x;
    }

    @Property(name="uniqueId")
    @JsonIgnore
    public Optional<String> getUniqueId() {
        return Optional.ofNullable(uniqueId);
    }

    public Location withUniqueId(String uniqueId) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.uniqueId = uniqueId;
        return _x;
    }

    @Property(name="uniqueIdType")
    @JsonIgnore
    public Optional<LocationUniqueIdType> getUniqueIdType() {
        return Optional.ofNullable(uniqueIdType);
    }

    public Location withUniqueIdType(LocationUniqueIdType uniqueIdType) {
        Location _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.location");
        _x.uniqueIdType = uniqueIdType;
        return _x;
    }

    public Location withUnmappedField(String name, Object value) {
        Location _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PhysicalAddress address;
        private OutlookGeoCoordinates coordinates;
        private String displayName;
        private String locationEmailAddress;
        private LocationType locationType;
        private String locationUri;
        private String uniqueId;
        private LocationUniqueIdType uniqueIdType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder coordinates(OutlookGeoCoordinates coordinates) {
            this.coordinates = coordinates;
            this.changedFields = changedFields.add("coordinates");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder locationEmailAddress(String locationEmailAddress) {
            this.locationEmailAddress = locationEmailAddress;
            this.changedFields = changedFields.add("locationEmailAddress");
            return this;
        }

        public Builder locationType(LocationType locationType) {
            this.locationType = locationType;
            this.changedFields = changedFields.add("locationType");
            return this;
        }

        public Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            this.changedFields = changedFields.add("locationUri");
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            this.changedFields = changedFields.add("uniqueId");
            return this;
        }

        public Builder uniqueIdType(LocationUniqueIdType uniqueIdType) {
            this.uniqueIdType = uniqueIdType;
            this.changedFields = changedFields.add("uniqueIdType");
            return this;
        }

        public Location build() {
            Location _x = new Location();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.location";
            _x.address = address;
            _x.coordinates = coordinates;
            _x.displayName = displayName;
            _x.locationEmailAddress = locationEmailAddress;
            _x.locationType = locationType;
            _x.locationUri = locationUri;
            _x.uniqueId = uniqueId;
            _x.uniqueIdType = uniqueIdType;
            return _x;
        }
    }

    private Location _copy() {
        Location _x = new Location();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.coordinates = coordinates;
        _x.displayName = displayName;
        _x.locationEmailAddress = locationEmailAddress;
        _x.locationType = locationType;
        _x.locationUri = locationUri;
        _x.uniqueId = uniqueId;
        _x.uniqueIdType = uniqueIdType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Location[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("coordinates=");
        b.append(this.coordinates);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("locationEmailAddress=");
        b.append(this.locationEmailAddress);
        b.append(", ");
        b.append("locationType=");
        b.append(this.locationType);
        b.append(", ");
        b.append("locationUri=");
        b.append(this.locationUri);
        b.append(", ");
        b.append("uniqueId=");
        b.append(this.uniqueId);
        b.append(", ");
        b.append("uniqueIdType=");
        b.append(this.uniqueIdType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
