package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.LobbyBypassScope;

@JsonPropertyOrder({
    "@odata.type", 
    "isDialInBypassEnabled", 
    "scope"})
@JsonInclude(Include.NON_NULL)
public class LobbyBypassSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isDialInBypassEnabled")
    protected Boolean isDialInBypassEnabled;

    @JsonProperty("scope")
    protected LobbyBypassScope scope;

    protected LobbyBypassSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.lobbyBypassSettings";
    }

    @Property(name="isDialInBypassEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDialInBypassEnabled() {
        return Optional.ofNullable(isDialInBypassEnabled);
    }

    public LobbyBypassSettings withIsDialInBypassEnabled(Boolean isDialInBypassEnabled) {
        LobbyBypassSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lobbyBypassSettings");
        _x.isDialInBypassEnabled = isDialInBypassEnabled;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<LobbyBypassScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public LobbyBypassSettings withScope(LobbyBypassScope scope) {
        LobbyBypassSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lobbyBypassSettings");
        _x.scope = scope;
        return _x;
    }

    public LobbyBypassSettings withUnmappedField(String name, Object value) {
        LobbyBypassSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isDialInBypassEnabled;
        private LobbyBypassScope scope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isDialInBypassEnabled(Boolean isDialInBypassEnabled) {
            this.isDialInBypassEnabled = isDialInBypassEnabled;
            this.changedFields = changedFields.add("isDialInBypassEnabled");
            return this;
        }

        public Builder scope(LobbyBypassScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public LobbyBypassSettings build() {
            LobbyBypassSettings _x = new LobbyBypassSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.lobbyBypassSettings";
            _x.isDialInBypassEnabled = isDialInBypassEnabled;
            _x.scope = scope;
            return _x;
        }
    }

    private LobbyBypassSettings _copy() {
        LobbyBypassSettings _x = new LobbyBypassSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isDialInBypassEnabled = isDialInBypassEnabled;
        _x.scope = scope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LobbyBypassSettings[");
        b.append("isDialInBypassEnabled=");
        b.append(this.isDialInBypassEnabled);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
