package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contentTypesEnabled", 
    "hidden", 
    "template"})
@JsonInclude(Include.NON_NULL)
public class ListInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentTypesEnabled")
    protected Boolean contentTypesEnabled;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("template")
    protected String template;

    protected ListInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.listInfo";
    }

    @Property(name="contentTypesEnabled")
    @JsonIgnore
    public Optional<Boolean> getContentTypesEnabled() {
        return Optional.ofNullable(contentTypesEnabled);
    }

    public ListInfo withContentTypesEnabled(Boolean contentTypesEnabled) {
        ListInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listInfo");
        _x.contentTypesEnabled = contentTypesEnabled;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public ListInfo withHidden(Boolean hidden) {
        ListInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listInfo");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="template")
    @JsonIgnore
    public Optional<String> getTemplate() {
        return Optional.ofNullable(template);
    }

    public ListInfo withTemplate(String template) {
        ListInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listInfo");
        _x.template = template;
        return _x;
    }

    public ListInfo withUnmappedField(String name, Object value) {
        ListInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean contentTypesEnabled;
        private Boolean hidden;
        private String template;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentTypesEnabled(Boolean contentTypesEnabled) {
            this.contentTypesEnabled = contentTypesEnabled;
            this.changedFields = changedFields.add("contentTypesEnabled");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            this.changedFields = changedFields.add("template");
            return this;
        }

        public ListInfo build() {
            ListInfo _x = new ListInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.listInfo";
            _x.contentTypesEnabled = contentTypesEnabled;
            _x.hidden = hidden;
            _x.template = template;
            return _x;
        }
    }

    private ListInfo _copy() {
        ListInfo _x = new ListInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentTypesEnabled = contentTypesEnabled;
        _x.hidden = hidden;
        _x.template = template;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ListInfo[");
        b.append("contentTypesEnabled=");
        b.append(this.contentTypesEnabled);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("template=");
        b.append(this.template);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
