package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AzureADLicenseType;

@JsonPropertyOrder({
    "@odata.type", 
    "licenseType", 
    "totalAssignedCount", 
    "totalLicenseCount", 
    "totalUsageCount"})
@JsonInclude(Include.NON_NULL)
public class LicenseInfoDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("licenseType")
    protected AzureADLicenseType licenseType;

    @JsonProperty("totalAssignedCount")
    protected Integer totalAssignedCount;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("totalUsageCount")
    protected Integer totalUsageCount;

    protected LicenseInfoDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.licenseInfoDetail";
    }

    @Property(name="licenseType")
    @JsonIgnore
    public Optional<AzureADLicenseType> getLicenseType() {
        return Optional.ofNullable(licenseType);
    }

    public LicenseInfoDetail withLicenseType(AzureADLicenseType licenseType) {
        LicenseInfoDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseInfoDetail");
        _x.licenseType = licenseType;
        return _x;
    }

    @Property(name="totalAssignedCount")
    @JsonIgnore
    public Optional<Integer> getTotalAssignedCount() {
        return Optional.ofNullable(totalAssignedCount);
    }

    public LicenseInfoDetail withTotalAssignedCount(Integer totalAssignedCount) {
        LicenseInfoDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseInfoDetail");
        _x.totalAssignedCount = totalAssignedCount;
        return _x;
    }

    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    public LicenseInfoDetail withTotalLicenseCount(Integer totalLicenseCount) {
        LicenseInfoDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseInfoDetail");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    @Property(name="totalUsageCount")
    @JsonIgnore
    public Optional<Integer> getTotalUsageCount() {
        return Optional.ofNullable(totalUsageCount);
    }

    public LicenseInfoDetail withTotalUsageCount(Integer totalUsageCount) {
        LicenseInfoDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseInfoDetail");
        _x.totalUsageCount = totalUsageCount;
        return _x;
    }

    public LicenseInfoDetail withUnmappedField(String name, Object value) {
        LicenseInfoDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AzureADLicenseType licenseType;
        private Integer totalAssignedCount;
        private Integer totalLicenseCount;
        private Integer totalUsageCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder licenseType(AzureADLicenseType licenseType) {
            this.licenseType = licenseType;
            this.changedFields = changedFields.add("licenseType");
            return this;
        }

        public Builder totalAssignedCount(Integer totalAssignedCount) {
            this.totalAssignedCount = totalAssignedCount;
            this.changedFields = changedFields.add("totalAssignedCount");
            return this;
        }

        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        public Builder totalUsageCount(Integer totalUsageCount) {
            this.totalUsageCount = totalUsageCount;
            this.changedFields = changedFields.add("totalUsageCount");
            return this;
        }

        public LicenseInfoDetail build() {
            LicenseInfoDetail _x = new LicenseInfoDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.licenseInfoDetail";
            _x.licenseType = licenseType;
            _x.totalAssignedCount = totalAssignedCount;
            _x.totalLicenseCount = totalLicenseCount;
            _x.totalUsageCount = totalUsageCount;
            return _x;
        }
    }

    private LicenseInfoDetail _copy() {
        LicenseInfoDetail _x = new LicenseInfoDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.licenseType = licenseType;
        _x.totalAssignedCount = totalAssignedCount;
        _x.totalLicenseCount = totalLicenseCount;
        _x.totalUsageCount = totalUsageCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LicenseInfoDetail[");
        b.append("licenseType=");
        b.append(this.licenseType);
        b.append(", ");
        b.append("totalAssignedCount=");
        b.append(this.totalAssignedCount);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("totalUsageCount=");
        b.append(this.totalUsageCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
