package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedByGroup", 
    "disabledPlans", 
    "error", 
    "lastUpdatedDateTime", 
    "skuId", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class LicenseAssignmentState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedByGroup")
    protected String assignedByGroup;

    @JsonProperty("disabledPlans")
    protected List<UUID> disabledPlans;

    @JsonProperty("disabledPlans@nextLink")
    protected String disabledPlansNextLink;

    @JsonProperty("error")
    protected String error;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("skuId")
    protected UUID skuId;

    @JsonProperty("state")
    protected String state;

    protected LicenseAssignmentState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.licenseAssignmentState";
    }

    @Property(name="assignedByGroup")
    @JsonIgnore
    public Optional<String> getAssignedByGroup() {
        return Optional.ofNullable(assignedByGroup);
    }

    public LicenseAssignmentState withAssignedByGroup(String assignedByGroup) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.assignedByGroup = assignedByGroup;
        return _x;
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<UUID> getDisabledPlans() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.disabledPlans, Optional.ofNullable(disabledPlansNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<UUID> getDisabledPlans(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.disabledPlans, Optional.ofNullable(disabledPlansNextLink), Collections.emptyList(), options);
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public LicenseAssignmentState withError(String error) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.error = error;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public LicenseAssignmentState withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="skuId")
    @JsonIgnore
    public Optional<UUID> getSkuId() {
        return Optional.ofNullable(skuId);
    }

    public LicenseAssignmentState withSkuId(UUID skuId) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.skuId = skuId;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public LicenseAssignmentState withState(String state) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.state = state;
        return _x;
    }

    public LicenseAssignmentState withUnmappedField(String name, Object value) {
        LicenseAssignmentState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String assignedByGroup;
        private List<UUID> disabledPlans;
        private String disabledPlansNextLink;
        private String error;
        private OffsetDateTime lastUpdatedDateTime;
        private UUID skuId;
        private String state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedByGroup(String assignedByGroup) {
            this.assignedByGroup = assignedByGroup;
            this.changedFields = changedFields.add("assignedByGroup");
            return this;
        }

        public Builder disabledPlans(List<UUID> disabledPlans) {
            this.disabledPlans = disabledPlans;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder disabledPlans(UUID... disabledPlans) {
            return disabledPlans(Arrays.asList(disabledPlans));
        }

        public Builder disabledPlansNextLink(String disabledPlansNextLink) {
            this.disabledPlansNextLink = disabledPlansNextLink;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder skuId(UUID skuId) {
            this.skuId = skuId;
            this.changedFields = changedFields.add("skuId");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public LicenseAssignmentState build() {
            LicenseAssignmentState _x = new LicenseAssignmentState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.licenseAssignmentState";
            _x.assignedByGroup = assignedByGroup;
            _x.disabledPlans = disabledPlans;
            _x.disabledPlansNextLink = disabledPlansNextLink;
            _x.error = error;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.skuId = skuId;
            _x.state = state;
            return _x;
        }
    }

    private LicenseAssignmentState _copy() {
        LicenseAssignmentState _x = new LicenseAssignmentState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedByGroup = assignedByGroup;
        _x.disabledPlans = disabledPlans;
        _x.error = error;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.skuId = skuId;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LicenseAssignmentState[");
        b.append("assignedByGroup=");
        b.append(this.assignedByGroup);
        b.append(", ");
        b.append("disabledPlans=");
        b.append(this.disabledPlans);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("skuId=");
        b.append(this.skuId);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
