package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A key-value pair with a string key and a typed value.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "key"})
@JsonInclude(Include.NON_NULL)
public class KeyTypedValuePair implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("key")
    protected String key;

    protected KeyTypedValuePair() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.keyTypedValuePair";
    }

    /**
     * <i>“The string key of the key-value pair.”</i>
     * 
     * @return property key
     */
    @Property(name="key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code key} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The string key of the key-value pair.”</i>
     * 
     * @param key
     *            new value of {@code key} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code key} field changed
     */
    public KeyTypedValuePair withKey(String key) {
        KeyTypedValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyTypedValuePair");
        _x.key = key;
        return _x;
    }

    public KeyTypedValuePair withUnmappedField(String name, Object value) {
        KeyTypedValuePair _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private KeyTypedValuePair _copy() {
        KeyTypedValuePair _x = new KeyTypedValuePair();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.key = key;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyTypedValuePair[");
        b.append("key=");
        b.append(this.key);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
