package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AppKeyCredentialRestrictionType;

@JsonPropertyOrder({
    "@odata.type", 
    "maxLifetime", 
    "restrictForAppsCreatedAfterDateTime", 
    "restrictionType"})
@JsonInclude(Include.NON_NULL)
public class KeyCredentialConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("maxLifetime")
    protected Duration maxLifetime;

    @JsonProperty("restrictForAppsCreatedAfterDateTime")
    protected OffsetDateTime restrictForAppsCreatedAfterDateTime;

    @JsonProperty("restrictionType")
    protected AppKeyCredentialRestrictionType restrictionType;

    protected KeyCredentialConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.keyCredentialConfiguration";
    }

    @Property(name="maxLifetime")
    @JsonIgnore
    public Optional<Duration> getMaxLifetime() {
        return Optional.ofNullable(maxLifetime);
    }

    public KeyCredentialConfiguration withMaxLifetime(Duration maxLifetime) {
        KeyCredentialConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyCredentialConfiguration");
        _x.maxLifetime = maxLifetime;
        return _x;
    }

    @Property(name="restrictForAppsCreatedAfterDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRestrictForAppsCreatedAfterDateTime() {
        return Optional.ofNullable(restrictForAppsCreatedAfterDateTime);
    }

    public KeyCredentialConfiguration withRestrictForAppsCreatedAfterDateTime(OffsetDateTime restrictForAppsCreatedAfterDateTime) {
        KeyCredentialConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyCredentialConfiguration");
        _x.restrictForAppsCreatedAfterDateTime = restrictForAppsCreatedAfterDateTime;
        return _x;
    }

    @Property(name="restrictionType")
    @JsonIgnore
    public Optional<AppKeyCredentialRestrictionType> getRestrictionType() {
        return Optional.ofNullable(restrictionType);
    }

    public KeyCredentialConfiguration withRestrictionType(AppKeyCredentialRestrictionType restrictionType) {
        KeyCredentialConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyCredentialConfiguration");
        _x.restrictionType = restrictionType;
        return _x;
    }

    public KeyCredentialConfiguration withUnmappedField(String name, Object value) {
        KeyCredentialConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration maxLifetime;
        private OffsetDateTime restrictForAppsCreatedAfterDateTime;
        private AppKeyCredentialRestrictionType restrictionType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder maxLifetime(Duration maxLifetime) {
            this.maxLifetime = maxLifetime;
            this.changedFields = changedFields.add("maxLifetime");
            return this;
        }

        public Builder restrictForAppsCreatedAfterDateTime(OffsetDateTime restrictForAppsCreatedAfterDateTime) {
            this.restrictForAppsCreatedAfterDateTime = restrictForAppsCreatedAfterDateTime;
            this.changedFields = changedFields.add("restrictForAppsCreatedAfterDateTime");
            return this;
        }

        public Builder restrictionType(AppKeyCredentialRestrictionType restrictionType) {
            this.restrictionType = restrictionType;
            this.changedFields = changedFields.add("restrictionType");
            return this;
        }

        public KeyCredentialConfiguration build() {
            KeyCredentialConfiguration _x = new KeyCredentialConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.keyCredentialConfiguration";
            _x.maxLifetime = maxLifetime;
            _x.restrictForAppsCreatedAfterDateTime = restrictForAppsCreatedAfterDateTime;
            _x.restrictionType = restrictionType;
            return _x;
        }
    }

    private KeyCredentialConfiguration _copy() {
        KeyCredentialConfiguration _x = new KeyCredentialConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maxLifetime = maxLifetime;
        _x.restrictForAppsCreatedAfterDateTime = restrictForAppsCreatedAfterDateTime;
        _x.restrictionType = restrictionType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyCredentialConfiguration[");
        b.append("maxLifetime=");
        b.append(this.maxLifetime);
        b.append(", ");
        b.append("restrictForAppsCreatedAfterDateTime=");
        b.append(this.restrictForAppsCreatedAfterDateTime);
        b.append(", ");
        b.append("restrictionType=");
        b.append(this.restrictionType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
