package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "driveId", 
    "driveType", 
    "id", 
    "name", 
    "path", 
    "shareId", 
    "sharepointIds", 
    "siteId"})
@JsonInclude(Include.NON_NULL)
public class ItemReference implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("driveId")
    protected String driveId;

    @JsonProperty("driveType")
    protected String driveType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("shareId")
    protected String shareId;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("siteId")
    protected String siteId;

    protected ItemReference() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemReference";
    }

    @Property(name="driveId")
    @JsonIgnore
    public Optional<String> getDriveId() {
        return Optional.ofNullable(driveId);
    }

    public ItemReference withDriveId(String driveId) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.driveId = driveId;
        return _x;
    }

    @Property(name="driveType")
    @JsonIgnore
    public Optional<String> getDriveType() {
        return Optional.ofNullable(driveType);
    }

    public ItemReference withDriveType(String driveType) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.driveType = driveType;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ItemReference withId(String id) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.id = id;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ItemReference withName(String name) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.name = name;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public ItemReference withPath(String path) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.path = path;
        return _x;
    }

    @Property(name="shareId")
    @JsonIgnore
    public Optional<String> getShareId() {
        return Optional.ofNullable(shareId);
    }

    public ItemReference withShareId(String shareId) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.shareId = shareId;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public ItemReference withSharepointIds(SharepointIds sharepointIds) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    @Property(name="siteId")
    @JsonIgnore
    public Optional<String> getSiteId() {
        return Optional.ofNullable(siteId);
    }

    public ItemReference withSiteId(String siteId) {
        ItemReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemReference");
        _x.siteId = siteId;
        return _x;
    }

    public ItemReference withUnmappedField(String name, Object value) {
        ItemReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String driveId;
        private String driveType;
        private String id;
        private String name;
        private String path;
        private String shareId;
        private SharepointIds sharepointIds;
        private String siteId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder driveId(String driveId) {
            this.driveId = driveId;
            this.changedFields = changedFields.add("driveId");
            return this;
        }

        public Builder driveType(String driveType) {
            this.driveType = driveType;
            this.changedFields = changedFields.add("driveType");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder shareId(String shareId) {
            this.shareId = shareId;
            this.changedFields = changedFields.add("shareId");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder siteId(String siteId) {
            this.siteId = siteId;
            this.changedFields = changedFields.add("siteId");
            return this;
        }

        public ItemReference build() {
            ItemReference _x = new ItemReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemReference";
            _x.driveId = driveId;
            _x.driveType = driveType;
            _x.id = id;
            _x.name = name;
            _x.path = path;
            _x.shareId = shareId;
            _x.sharepointIds = sharepointIds;
            _x.siteId = siteId;
            return _x;
        }
    }

    private ItemReference _copy() {
        ItemReference _x = new ItemReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.driveId = driveId;
        _x.driveType = driveType;
        _x.id = id;
        _x.name = name;
        _x.path = path;
        _x.shareId = shareId;
        _x.sharepointIds = sharepointIds;
        _x.siteId = siteId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemReference[");
        b.append("driveId=");
        b.append(this.driveId);
        b.append(", ");
        b.append("driveType=");
        b.append(this.driveType);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("shareId=");
        b.append(this.shareId);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("siteId=");
        b.append(this.siteId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
