package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "getUrl", 
    "postParameters", 
    "postUrl"})
@JsonInclude(Include.NON_NULL)
public class ItemPreviewInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("getUrl")
    protected String getUrl;

    @JsonProperty("postParameters")
    protected String postParameters;

    @JsonProperty("postUrl")
    protected String postUrl;

    protected ItemPreviewInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemPreviewInfo";
    }

    @Property(name="getUrl")
    @JsonIgnore
    public Optional<String> getGetUrl() {
        return Optional.ofNullable(getUrl);
    }

    public ItemPreviewInfo withGetUrl(String getUrl) {
        ItemPreviewInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPreviewInfo");
        _x.getUrl = getUrl;
        return _x;
    }

    @Property(name="postParameters")
    @JsonIgnore
    public Optional<String> getPostParameters() {
        return Optional.ofNullable(postParameters);
    }

    public ItemPreviewInfo withPostParameters(String postParameters) {
        ItemPreviewInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPreviewInfo");
        _x.postParameters = postParameters;
        return _x;
    }

    @Property(name="postUrl")
    @JsonIgnore
    public Optional<String> getPostUrl() {
        return Optional.ofNullable(postUrl);
    }

    public ItemPreviewInfo withPostUrl(String postUrl) {
        ItemPreviewInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemPreviewInfo");
        _x.postUrl = postUrl;
        return _x;
    }

    public ItemPreviewInfo withUnmappedField(String name, Object value) {
        ItemPreviewInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String getUrl;
        private String postParameters;
        private String postUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder getUrl(String getUrl) {
            this.getUrl = getUrl;
            this.changedFields = changedFields.add("getUrl");
            return this;
        }

        public Builder postParameters(String postParameters) {
            this.postParameters = postParameters;
            this.changedFields = changedFields.add("postParameters");
            return this;
        }

        public Builder postUrl(String postUrl) {
            this.postUrl = postUrl;
            this.changedFields = changedFields.add("postUrl");
            return this;
        }

        public ItemPreviewInfo build() {
            ItemPreviewInfo _x = new ItemPreviewInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemPreviewInfo";
            _x.getUrl = getUrl;
            _x.postParameters = postParameters;
            _x.postUrl = postUrl;
            return _x;
        }
    }

    private ItemPreviewInfo _copy() {
        ItemPreviewInfo _x = new ItemPreviewInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.getUrl = getUrl;
        _x.postParameters = postParameters;
        _x.postUrl = postUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemPreviewInfo[");
        b.append("getUrl=");
        b.append(this.getUrl);
        b.append(", ");
        b.append("postParameters=");
        b.append(this.postParameters);
        b.append(", ");
        b.append("postUrl=");
        b.append(this.postUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
