package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "comment", 
    "create", 
    "delete", 
    "edit", 
    "mention", 
    "move", 
    "rename", 
    "restore", 
    "share", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ItemActionSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("comment")
    protected CommentAction comment;

    @JsonProperty("create")
    protected CreateAction create;

    @JsonProperty("delete")
    protected DeleteAction delete;

    @JsonProperty("edit")
    protected EditAction edit;

    @JsonProperty("mention")
    protected MentionAction mention;

    @JsonProperty("move")
    protected MoveAction move;

    @JsonProperty("rename")
    protected RenameAction rename;

    @JsonProperty("restore")
    protected RestoreAction restore;

    @JsonProperty("share")
    protected ShareAction share;

    @JsonProperty("version")
    protected VersionAction version;

    protected ItemActionSet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActionSet";
    }

    @Property(name="comment")
    @JsonIgnore
    public Optional<CommentAction> getComment() {
        return Optional.ofNullable(comment);
    }

    public ItemActionSet withComment(CommentAction comment) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.comment = comment;
        return _x;
    }

    @Property(name="create")
    @JsonIgnore
    public Optional<CreateAction> getCreate() {
        return Optional.ofNullable(create);
    }

    public ItemActionSet withCreate(CreateAction create) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.create = create;
        return _x;
    }

    @Property(name="delete")
    @JsonIgnore
    public Optional<DeleteAction> getDelete() {
        return Optional.ofNullable(delete);
    }

    public ItemActionSet withDelete(DeleteAction delete) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.delete = delete;
        return _x;
    }

    @Property(name="edit")
    @JsonIgnore
    public Optional<EditAction> getEdit() {
        return Optional.ofNullable(edit);
    }

    public ItemActionSet withEdit(EditAction edit) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.edit = edit;
        return _x;
    }

    @Property(name="mention")
    @JsonIgnore
    public Optional<MentionAction> getMention() {
        return Optional.ofNullable(mention);
    }

    public ItemActionSet withMention(MentionAction mention) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.mention = mention;
        return _x;
    }

    @Property(name="move")
    @JsonIgnore
    public Optional<MoveAction> getMove() {
        return Optional.ofNullable(move);
    }

    public ItemActionSet withMove(MoveAction move) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.move = move;
        return _x;
    }

    @Property(name="rename")
    @JsonIgnore
    public Optional<RenameAction> getRename() {
        return Optional.ofNullable(rename);
    }

    public ItemActionSet withRename(RenameAction rename) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.rename = rename;
        return _x;
    }

    @Property(name="restore")
    @JsonIgnore
    public Optional<RestoreAction> getRestore() {
        return Optional.ofNullable(restore);
    }

    public ItemActionSet withRestore(RestoreAction restore) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.restore = restore;
        return _x;
    }

    @Property(name="share")
    @JsonIgnore
    public Optional<ShareAction> getShare() {
        return Optional.ofNullable(share);
    }

    public ItemActionSet withShare(ShareAction share) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.share = share;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<VersionAction> getVersion() {
        return Optional.ofNullable(version);
    }

    public ItemActionSet withVersion(VersionAction version) {
        ItemActionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionSet");
        _x.version = version;
        return _x;
    }

    public ItemActionSet withUnmappedField(String name, Object value) {
        ItemActionSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CommentAction comment;
        private CreateAction create;
        private DeleteAction delete;
        private EditAction edit;
        private MentionAction mention;
        private MoveAction move;
        private RenameAction rename;
        private RestoreAction restore;
        private ShareAction share;
        private VersionAction version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder comment(CommentAction comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("comment");
            return this;
        }

        public Builder create(CreateAction create) {
            this.create = create;
            this.changedFields = changedFields.add("create");
            return this;
        }

        public Builder delete(DeleteAction delete) {
            this.delete = delete;
            this.changedFields = changedFields.add("delete");
            return this;
        }

        public Builder edit(EditAction edit) {
            this.edit = edit;
            this.changedFields = changedFields.add("edit");
            return this;
        }

        public Builder mention(MentionAction mention) {
            this.mention = mention;
            this.changedFields = changedFields.add("mention");
            return this;
        }

        public Builder move(MoveAction move) {
            this.move = move;
            this.changedFields = changedFields.add("move");
            return this;
        }

        public Builder rename(RenameAction rename) {
            this.rename = rename;
            this.changedFields = changedFields.add("rename");
            return this;
        }

        public Builder restore(RestoreAction restore) {
            this.restore = restore;
            this.changedFields = changedFields.add("restore");
            return this;
        }

        public Builder share(ShareAction share) {
            this.share = share;
            this.changedFields = changedFields.add("share");
            return this;
        }

        public Builder version(VersionAction version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public ItemActionSet build() {
            ItemActionSet _x = new ItemActionSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemActionSet";
            _x.comment = comment;
            _x.create = create;
            _x.delete = delete;
            _x.edit = edit;
            _x.mention = mention;
            _x.move = move;
            _x.rename = rename;
            _x.restore = restore;
            _x.share = share;
            _x.version = version;
            return _x;
        }
    }

    private ItemActionSet _copy() {
        ItemActionSet _x = new ItemActionSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.comment = comment;
        _x.create = create;
        _x.delete = delete;
        _x.edit = edit;
        _x.mention = mention;
        _x.move = move;
        _x.rename = rename;
        _x.restore = restore;
        _x.share = share;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActionSet[");
        b.append("comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("create=");
        b.append(this.create);
        b.append(", ");
        b.append("delete=");
        b.append(this.delete);
        b.append(", ");
        b.append("edit=");
        b.append(this.edit);
        b.append(", ");
        b.append("mention=");
        b.append(this.mention);
        b.append(", ");
        b.append("move=");
        b.append(this.move);
        b.append(", ");
        b.append("rename=");
        b.append(this.rename);
        b.append(", ");
        b.append("restore=");
        b.append(this.restore);
        b.append(", ");
        b.append("share=");
        b.append(this.share);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
