package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "name", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class IpCategory implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("vendor")
    protected String vendor;

    protected IpCategory() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ipCategory";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public IpCategory withDescription(String description) {
        IpCategory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipCategory");
        _x.description = description;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public IpCategory withName(String name) {
        IpCategory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipCategory");
        _x.name = name;
        return _x;
    }

    @Property(name="vendor")
    @JsonIgnore
    public Optional<String> getVendor() {
        return Optional.ofNullable(vendor);
    }

    public IpCategory withVendor(String vendor) {
        IpCategory _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipCategory");
        _x.vendor = vendor;
        return _x;
    }

    public IpCategory withUnmappedField(String name, Object value) {
        IpCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String name;
        private String vendor;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public IpCategory build() {
            IpCategory _x = new IpCategory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.ipCategory";
            _x.description = description;
            _x.name = name;
            _x.vendor = vendor;
            return _x;
        }
    }

    private IpCategory _copy() {
        IpCategory _x = new IpCategory();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.name = name;
        _x.vendor = vendor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IpCategory[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
