package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties of the minimum operating system required for an iOS mobile
 * app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "v10_0", 
    "v11_0", 
    "v12_0", 
    "v13_0", 
    "v14_0", 
    "v8_0", 
    "v9_0"})
@JsonInclude(Include.NON_NULL)
public class IosMinimumOperatingSystem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("v10_0")
    protected Boolean v10_0;

    @JsonProperty("v11_0")
    protected Boolean v11_0;

    @JsonProperty("v12_0")
    protected Boolean v12_0;

    @JsonProperty("v13_0")
    protected Boolean v13_0;

    @JsonProperty("v14_0")
    protected Boolean v14_0;

    @JsonProperty("v8_0")
    protected Boolean v8_0;

    @JsonProperty("v9_0")
    protected Boolean v9_0;

    protected IosMinimumOperatingSystem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosMinimumOperatingSystem";
    }

    /**
     * <i>“Version 10.0 or later.”</i>
     * 
     * @return property v10_0
     */
    @Property(name="v10_0")
    @JsonIgnore
    public Optional<Boolean> getV10_0() {
        return Optional.ofNullable(v10_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 10.0 or later.”</i>
     * 
     * @param v10_0
     *            new value of {@code v10_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_0} field changed
     */
    public IosMinimumOperatingSystem withV10_0(Boolean v10_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v10_0 = v10_0;
        return _x;
    }

    /**
     * <i>“Version 11.0 or later.”</i>
     * 
     * @return property v11_0
     */
    @Property(name="v11_0")
    @JsonIgnore
    public Optional<Boolean> getV11_0() {
        return Optional.ofNullable(v11_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v11_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 11.0 or later.”</i>
     * 
     * @param v11_0
     *            new value of {@code v11_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v11_0} field changed
     */
    public IosMinimumOperatingSystem withV11_0(Boolean v11_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v11_0 = v11_0;
        return _x;
    }

    /**
     * <i>“Version 12.0 or later.”</i>
     * 
     * @return property v12_0
     */
    @Property(name="v12_0")
    @JsonIgnore
    public Optional<Boolean> getV12_0() {
        return Optional.ofNullable(v12_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v12_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 12.0 or later.”</i>
     * 
     * @param v12_0
     *            new value of {@code v12_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v12_0} field changed
     */
    public IosMinimumOperatingSystem withV12_0(Boolean v12_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v12_0 = v12_0;
        return _x;
    }

    /**
     * <i>“Version 13.0 or later.”</i>
     * 
     * @return property v13_0
     */
    @Property(name="v13_0")
    @JsonIgnore
    public Optional<Boolean> getV13_0() {
        return Optional.ofNullable(v13_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v13_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 13.0 or later.”</i>
     * 
     * @param v13_0
     *            new value of {@code v13_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v13_0} field changed
     */
    public IosMinimumOperatingSystem withV13_0(Boolean v13_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v13_0 = v13_0;
        return _x;
    }

    /**
     * <i>“Version 14.0 or later.”</i>
     * 
     * @return property v14_0
     */
    @Property(name="v14_0")
    @JsonIgnore
    public Optional<Boolean> getV14_0() {
        return Optional.ofNullable(v14_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v14_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 14.0 or later.”</i>
     * 
     * @param v14_0
     *            new value of {@code v14_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v14_0} field changed
     */
    public IosMinimumOperatingSystem withV14_0(Boolean v14_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v14_0 = v14_0;
        return _x;
    }

    /**
     * <i>“Version 8.0 or later.”</i>
     * 
     * @return property v8_0
     */
    @Property(name="v8_0")
    @JsonIgnore
    public Optional<Boolean> getV8_0() {
        return Optional.ofNullable(v8_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v8_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 8.0 or later.”</i>
     * 
     * @param v8_0
     *            new value of {@code v8_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v8_0} field changed
     */
    public IosMinimumOperatingSystem withV8_0(Boolean v8_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v8_0 = v8_0;
        return _x;
    }

    /**
     * <i>“Version 9.0 or later.”</i>
     * 
     * @return property v9_0
     */
    @Property(name="v9_0")
    @JsonIgnore
    public Optional<Boolean> getV9_0() {
        return Optional.ofNullable(v9_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v9_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version 9.0 or later.”</i>
     * 
     * @param v9_0
     *            new value of {@code v9_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v9_0} field changed
     */
    public IosMinimumOperatingSystem withV9_0(Boolean v9_0) {
        IosMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMinimumOperatingSystem");
        _x.v9_0 = v9_0;
        return _x;
    }

    public IosMinimumOperatingSystem withUnmappedField(String name, Object value) {
        IosMinimumOperatingSystem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean v10_0;
        private Boolean v11_0;
        private Boolean v12_0;
        private Boolean v13_0;
        private Boolean v14_0;
        private Boolean v8_0;
        private Boolean v9_0;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Version 10.0 or later.”</i>
         * 
         * @param v10_0
         *            value of {@code v10_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_0(Boolean v10_0) {
            this.v10_0 = v10_0;
            this.changedFields = changedFields.add("v10_0");
            return this;
        }

        /**
         * <i>“Version 11.0 or later.”</i>
         * 
         * @param v11_0
         *            value of {@code v11_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v11_0(Boolean v11_0) {
            this.v11_0 = v11_0;
            this.changedFields = changedFields.add("v11_0");
            return this;
        }

        /**
         * <i>“Version 12.0 or later.”</i>
         * 
         * @param v12_0
         *            value of {@code v12_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v12_0(Boolean v12_0) {
            this.v12_0 = v12_0;
            this.changedFields = changedFields.add("v12_0");
            return this;
        }

        /**
         * <i>“Version 13.0 or later.”</i>
         * 
         * @param v13_0
         *            value of {@code v13_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v13_0(Boolean v13_0) {
            this.v13_0 = v13_0;
            this.changedFields = changedFields.add("v13_0");
            return this;
        }

        /**
         * <i>“Version 14.0 or later.”</i>
         * 
         * @param v14_0
         *            value of {@code v14_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v14_0(Boolean v14_0) {
            this.v14_0 = v14_0;
            this.changedFields = changedFields.add("v14_0");
            return this;
        }

        /**
         * <i>“Version 8.0 or later.”</i>
         * 
         * @param v8_0
         *            value of {@code v8_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v8_0(Boolean v8_0) {
            this.v8_0 = v8_0;
            this.changedFields = changedFields.add("v8_0");
            return this;
        }

        /**
         * <i>“Version 9.0 or later.”</i>
         * 
         * @param v9_0
         *            value of {@code v9_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v9_0(Boolean v9_0) {
            this.v9_0 = v9_0;
            this.changedFields = changedFields.add("v9_0");
            return this;
        }

        public IosMinimumOperatingSystem build() {
            IosMinimumOperatingSystem _x = new IosMinimumOperatingSystem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosMinimumOperatingSystem";
            _x.v10_0 = v10_0;
            _x.v11_0 = v11_0;
            _x.v12_0 = v12_0;
            _x.v13_0 = v13_0;
            _x.v14_0 = v14_0;
            _x.v8_0 = v8_0;
            _x.v9_0 = v9_0;
            return _x;
        }
    }

    private IosMinimumOperatingSystem _copy() {
        IosMinimumOperatingSystem _x = new IosMinimumOperatingSystem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.v10_0 = v10_0;
        _x.v11_0 = v11_0;
        _x.v12_0 = v12_0;
        _x.v13_0 = v13_0;
        _x.v14_0 = v14_0;
        _x.v8_0 = v8_0;
        _x.v9_0 = v9_0;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosMinimumOperatingSystem[");
        b.append("v10_0=");
        b.append(this.v10_0);
        b.append(", ");
        b.append("v11_0=");
        b.append(this.v11_0);
        b.append(", ");
        b.append("v12_0=");
        b.append(this.v12_0);
        b.append(", ");
        b.append("v13_0=");
        b.append(this.v13_0);
        b.append(", ");
        b.append("v14_0=");
        b.append(this.v14_0);
        b.append(", ");
        b.append("v8_0=");
        b.append(this.v8_0);
        b.append(", ");
        b.append("v9_0=");
        b.append(this.v9_0);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
