package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties used to assign an iOS LOB mobile app to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isRemovable", 
    "uninstallOnDeviceRemoval", 
    "vpnConfigurationId"})
@JsonInclude(Include.NON_NULL)
public class IosLobAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JsonProperty("isRemovable")
    protected Boolean isRemovable;

    @JsonProperty("uninstallOnDeviceRemoval")
    protected Boolean uninstallOnDeviceRemoval;

    @JsonProperty("vpnConfigurationId")
    protected String vpnConfigurationId;

    protected IosLobAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosLobAppAssignmentSettings";
    }

    /**
     * <i>“Whether or not the app can be removed by the user.”</i>
     * 
     * @return property isRemovable
     */
    @Property(name="isRemovable")
    @JsonIgnore
    public Optional<Boolean> getIsRemovable() {
        return Optional.ofNullable(isRemovable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isRemovable}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not the app can be removed by the user.”</i>
     * 
     * @param isRemovable
     *            new value of {@code isRemovable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isRemovable} field changed
     */
    public IosLobAppAssignmentSettings withIsRemovable(Boolean isRemovable) {
        IosLobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppAssignmentSettings");
        _x.isRemovable = isRemovable;
        return _x;
    }

    /**
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @return property uninstallOnDeviceRemoval
     */
    @Property(name="uninstallOnDeviceRemoval")
    @JsonIgnore
    public Optional<Boolean> getUninstallOnDeviceRemoval() {
        return Optional.ofNullable(uninstallOnDeviceRemoval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * uninstallOnDeviceRemoval} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @param uninstallOnDeviceRemoval
     *            new value of {@code uninstallOnDeviceRemoval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uninstallOnDeviceRemoval} field changed
     */
    public IosLobAppAssignmentSettings withUninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
        IosLobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppAssignmentSettings");
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        return _x;
    }

    /**
     * <i>“The VPN Configuration Id to apply for this app.”</i>
     * 
     * @return property vpnConfigurationId
     */
    @Property(name="vpnConfigurationId")
    @JsonIgnore
    public Optional<String> getVpnConfigurationId() {
        return Optional.ofNullable(vpnConfigurationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vpnConfigurationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The VPN Configuration Id to apply for this app.”</i>
     * 
     * @param vpnConfigurationId
     *            new value of {@code vpnConfigurationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnConfigurationId} field changed
     */
    public IosLobAppAssignmentSettings withVpnConfigurationId(String vpnConfigurationId) {
        IosLobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosLobAppAssignmentSettings");
        _x.vpnConfigurationId = vpnConfigurationId;
        return _x;
    }

    public IosLobAppAssignmentSettings withUnmappedField(String name, Object value) {
        IosLobAppAssignmentSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosLobAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRemovable;
        private Boolean uninstallOnDeviceRemoval;
        private String vpnConfigurationId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether or not the app can be removed by the user.”</i>
         * 
         * @param isRemovable
         *            value of {@code isRemovable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isRemovable(Boolean isRemovable) {
            this.isRemovable = isRemovable;
            this.changedFields = changedFields.add("isRemovable");
            return this;
        }

        /**
         * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
         * 
         * @param uninstallOnDeviceRemoval
         *            value of {@code uninstallOnDeviceRemoval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
            this.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            this.changedFields = changedFields.add("uninstallOnDeviceRemoval");
            return this;
        }

        /**
         * <i>“The VPN Configuration Id to apply for this app.”</i>
         * 
         * @param vpnConfigurationId
         *            value of {@code vpnConfigurationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnConfigurationId(String vpnConfigurationId) {
            this.vpnConfigurationId = vpnConfigurationId;
            this.changedFields = changedFields.add("vpnConfigurationId");
            return this;
        }

        public IosLobAppAssignmentSettings build() {
            IosLobAppAssignmentSettings _x = new IosLobAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosLobAppAssignmentSettings";
            _x.isRemovable = isRemovable;
            _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            _x.vpnConfigurationId = vpnConfigurationId;
            return _x;
        }
    }

    private IosLobAppAssignmentSettings _copy() {
        IosLobAppAssignmentSettings _x = new IosLobAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRemovable = isRemovable;
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        _x.vpnConfigurationId = vpnConfigurationId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosLobAppAssignmentSettings[");
        b.append("isRemovable=");
        b.append(this.isRemovable);
        b.append(", ");
        b.append("uninstallOnDeviceRemoval=");
        b.append(this.uninstallOnDeviceRemoval);
        b.append(", ");
        b.append("vpnConfigurationId=");
        b.append(this.vpnConfigurationId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
