package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents a Kerberos-type Single Sign-On extension profile for iOS devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "activeDirectorySiteCode", 
    "blockActiveDirectorySiteAutoDiscovery", 
    "blockAutomaticLogin", 
    "cacheName", 
    "credentialBundleIdAccessControlList", 
    "domainRealms", 
    "domains", 
    "isDefaultRealm", 
    "managedAppsInBundleIdACLIncluded", 
    "passwordBlockModification", 
    "passwordChangeUrl", 
    "passwordEnableLocalSync", 
    "passwordExpirationDays", 
    "passwordExpirationNotificationDays", 
    "passwordMinimumAgeDays", 
    "passwordMinimumLength", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequireActiveDirectoryComplexity", 
    "passwordRequirementsDescription", 
    "realm", 
    "requireUserPresence", 
    "signInHelpText", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class IosKerberosSingleSignOnExtension extends IosSingleSignOnExtension implements ODataType {

    @JsonProperty("activeDirectorySiteCode")
    protected String activeDirectorySiteCode;

    @JsonProperty("blockActiveDirectorySiteAutoDiscovery")
    protected Boolean blockActiveDirectorySiteAutoDiscovery;

    @JsonProperty("blockAutomaticLogin")
    protected Boolean blockAutomaticLogin;

    @JsonProperty("cacheName")
    protected String cacheName;

    @JsonProperty("credentialBundleIdAccessControlList")
    protected List<String> credentialBundleIdAccessControlList;

    @JsonProperty("credentialBundleIdAccessControlList@nextLink")
    protected String credentialBundleIdAccessControlListNextLink;

    @JsonProperty("domainRealms")
    protected List<String> domainRealms;

    @JsonProperty("domainRealms@nextLink")
    protected String domainRealmsNextLink;

    @JsonProperty("domains")
    protected List<String> domains;

    @JsonProperty("domains@nextLink")
    protected String domainsNextLink;

    @JsonProperty("isDefaultRealm")
    protected Boolean isDefaultRealm;

    @JsonProperty("managedAppsInBundleIdACLIncluded")
    protected Boolean managedAppsInBundleIdACLIncluded;

    @JsonProperty("passwordBlockModification")
    protected Boolean passwordBlockModification;

    @JsonProperty("passwordChangeUrl")
    protected String passwordChangeUrl;

    @JsonProperty("passwordEnableLocalSync")
    protected Boolean passwordEnableLocalSync;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordExpirationNotificationDays")
    protected Integer passwordExpirationNotificationDays;

    @JsonProperty("passwordMinimumAgeDays")
    protected Integer passwordMinimumAgeDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequireActiveDirectoryComplexity")
    protected Boolean passwordRequireActiveDirectoryComplexity;

    @JsonProperty("passwordRequirementsDescription")
    protected String passwordRequirementsDescription;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("requireUserPresence")
    protected Boolean requireUserPresence;

    @JsonProperty("signInHelpText")
    protected String signInHelpText;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected IosKerberosSingleSignOnExtension() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosKerberosSingleSignOnExtension";
    }

    /**
     * <i>“Gets or sets the Active Directory site.”</i>
     * 
     * @return property activeDirectorySiteCode
     */
    @Property(name="activeDirectorySiteCode")
    @JsonIgnore
    public Optional<String> getActiveDirectorySiteCode() {
        return Optional.ofNullable(activeDirectorySiteCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeDirectorySiteCode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the Active Directory site.”</i>
     * 
     * @param activeDirectorySiteCode
     *            new value of {@code activeDirectorySiteCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDirectorySiteCode} field changed
     */
    public IosKerberosSingleSignOnExtension withActiveDirectorySiteCode(String activeDirectorySiteCode) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.activeDirectorySiteCode = activeDirectorySiteCode;
        return _x;
    }

    /**
     * <i>“Enables or disables whether the Kerberos extension can automatically determine
     * its site name.”</i>
     * 
     * @return property blockActiveDirectorySiteAutoDiscovery
     */
    @Property(name="blockActiveDirectorySiteAutoDiscovery")
    @JsonIgnore
    public Optional<Boolean> getBlockActiveDirectorySiteAutoDiscovery() {
        return Optional.ofNullable(blockActiveDirectorySiteAutoDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockActiveDirectorySiteAutoDiscovery} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables whether the Kerberos extension can automatically determine
     * its site name.”</i>
     * 
     * @param blockActiveDirectorySiteAutoDiscovery
     *            new value of {@code blockActiveDirectorySiteAutoDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockActiveDirectorySiteAutoDiscovery} field changed
     */
    public IosKerberosSingleSignOnExtension withBlockActiveDirectorySiteAutoDiscovery(Boolean blockActiveDirectorySiteAutoDiscovery) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
        return _x;
    }

    /**
     * <i>“Enables or disables Keychain usage.”</i>
     * 
     * @return property blockAutomaticLogin
     */
    @Property(name="blockAutomaticLogin")
    @JsonIgnore
    public Optional<Boolean> getBlockAutomaticLogin() {
        return Optional.ofNullable(blockAutomaticLogin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockAutomaticLogin} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enables or disables Keychain usage.”</i>
     * 
     * @param blockAutomaticLogin
     *            new value of {@code blockAutomaticLogin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockAutomaticLogin} field changed
     */
    public IosKerberosSingleSignOnExtension withBlockAutomaticLogin(Boolean blockAutomaticLogin) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.blockAutomaticLogin = blockAutomaticLogin;
        return _x;
    }

    /**
     * <i>“Gets or sets the Generic Security Services name of the Kerberos cache to use for
     * this profile.”</i>
     * 
     * @return property cacheName
     */
    @Property(name="cacheName")
    @JsonIgnore
    public Optional<String> getCacheName() {
        return Optional.ofNullable(cacheName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cacheName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the Generic Security Services name of the Kerberos cache to use for
     * this profile.”</i>
     * 
     * @param cacheName
     *            new value of {@code cacheName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheName} field changed
     */
    public IosKerberosSingleSignOnExtension withCacheName(String cacheName) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.cacheName = cacheName;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
     * Granting Ticket.”</i>
     * 
     * @return property credentialBundleIdAccessControlList
     */
    @Property(name="credentialBundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getCredentialBundleIdAccessControlList() {
        return new CollectionPage<String>(contextPath, String.class, this.credentialBundleIdAccessControlList, Optional.ofNullable(credentialBundleIdAccessControlListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
     * Granting Ticket.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property credentialBundleIdAccessControlList
     */
    @Property(name="credentialBundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getCredentialBundleIdAccessControlList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.credentialBundleIdAccessControlList, Optional.ofNullable(credentialBundleIdAccessControlListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
     * sensitive.”</i>
     * 
     * @return property domainRealms
     */
    @Property(name="domainRealms")
    @JsonIgnore
    public CollectionPage<String> getDomainRealms() {
        return new CollectionPage<String>(contextPath, String.class, this.domainRealms, Optional.ofNullable(domainRealmsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
     * sensitive.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property domainRealms
     */
    @Property(name="domainRealms")
    @JsonIgnore
    public CollectionPage<String> getDomainRealms(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.domainRealms, Optional.ofNullable(domainRealmsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of hosts or domain names for which the app extension
     * performs SSO.”</i>
     * 
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains() {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of hosts or domain names for which the app extension
     * performs SSO.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.domains, Optional.ofNullable(domainsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“When true, this profile's realm will be selected as the default. Necessary if
     * multiple Kerberos-type profiles are configured.”</i>
     * 
     * @return property isDefaultRealm
     */
    @Property(name="isDefaultRealm")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultRealm() {
        return Optional.ofNullable(isDefaultRealm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefaultRealm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When true, this profile's realm will be selected as the default. Necessary if
     * multiple Kerberos-type profiles are configured.”</i>
     * 
     * @param isDefaultRealm
     *            new value of {@code isDefaultRealm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefaultRealm} field changed
     */
    public IosKerberosSingleSignOnExtension withIsDefaultRealm(Boolean isDefaultRealm) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.isDefaultRealm = isDefaultRealm;
        return _x;
    }

    /**
     * <i>“When set to True, the Kerberos extension allows managed apps, and any apps
     * entered with the app bundle ID to access the credential. When set to False, the
     * Kerberos extension allows all apps to access the credential. Available for
     * devices running iOS and iPadOS versions 14 and later.”</i>
     * 
     * @return property managedAppsInBundleIdACLIncluded
     */
    @Property(name="managedAppsInBundleIdACLIncluded")
    @JsonIgnore
    public Optional<Boolean> getManagedAppsInBundleIdACLIncluded() {
        return Optional.ofNullable(managedAppsInBundleIdACLIncluded);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedAppsInBundleIdACLIncluded} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When set to True, the Kerberos extension allows managed apps, and any apps
     * entered with the app bundle ID to access the credential. When set to False, the
     * Kerberos extension allows all apps to access the credential. Available for
     * devices running iOS and iPadOS versions 14 and later.”</i>
     * 
     * @param managedAppsInBundleIdACLIncluded
     *            new value of {@code managedAppsInBundleIdACLIncluded} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedAppsInBundleIdACLIncluded} field changed
     */
    public IosKerberosSingleSignOnExtension withManagedAppsInBundleIdACLIncluded(Boolean managedAppsInBundleIdACLIncluded) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.managedAppsInBundleIdACLIncluded = managedAppsInBundleIdACLIncluded;
        return _x;
    }

    /**
     * <i>“Enables or disables password changes.”</i>
     * 
     * @return property passwordBlockModification
     */
    @Property(name="passwordBlockModification")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockModification() {
        return Optional.ofNullable(passwordBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables password changes.”</i>
     * 
     * @param passwordBlockModification
     *            new value of {@code passwordBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockModification} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordBlockModification(Boolean passwordBlockModification) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordBlockModification = passwordBlockModification;
        return _x;
    }

    /**
     * <i>“Gets or sets the URL that the user will be sent to when they initiate a password
     * change.”</i>
     * 
     * @return property passwordChangeUrl
     */
    @Property(name="passwordChangeUrl")
    @JsonIgnore
    public Optional<String> getPasswordChangeUrl() {
        return Optional.ofNullable(passwordChangeUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordChangeUrl
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the URL that the user will be sent to when they initiate a password
     * change.”</i>
     * 
     * @param passwordChangeUrl
     *            new value of {@code passwordChangeUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordChangeUrl} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordChangeUrl(String passwordChangeUrl) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordChangeUrl = passwordChangeUrl;
        return _x;
    }

    /**
     * <i>“Enables or disables password syncing. This won't affect users logged in with a
     * mobile account on macOS.”</i>
     * 
     * @return property passwordEnableLocalSync
     */
    @Property(name="passwordEnableLocalSync")
    @JsonIgnore
    public Optional<Boolean> getPasswordEnableLocalSync() {
        return Optional.ofNullable(passwordEnableLocalSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordEnableLocalSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables password syncing. This won't affect users logged in with a
     * mobile account on macOS.”</i>
     * 
     * @param passwordEnableLocalSync
     *            new value of {@code passwordEnableLocalSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordEnableLocalSync} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordEnableLocalSync(Boolean passwordEnableLocalSync) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordEnableLocalSync = passwordEnableLocalSync;
        return _x;
    }

    /**
     * <i>“Overrides the default password expiration in days. For most domains, this value
     * is calculated automatically.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Overrides the default password expiration in days. For most domains, this value
     * is calculated automatically.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordExpirationDays(Integer passwordExpirationDays) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Gets or sets the number of days until the user is notified that their password
     * will expire (default is 15).”</i>
     * 
     * @return property passwordExpirationNotificationDays
     */
    @Property(name="passwordExpirationNotificationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationNotificationDays() {
        return Optional.ofNullable(passwordExpirationNotificationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationNotificationDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the number of days until the user is notified that their password
     * will expire (default is 15).”</i>
     * 
     * @param passwordExpirationNotificationDays
     *            new value of {@code passwordExpirationNotificationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationNotificationDays} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordExpirationNotificationDays(Integer passwordExpirationNotificationDays) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
        return _x;
    }

    /**
     * <i>“Gets or sets the minimum number of days until a user can change their password
     * again.”</i>
     * 
     * @return property passwordMinimumAgeDays
     */
    @Property(name="passwordMinimumAgeDays")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumAgeDays() {
        return Optional.ofNullable(passwordMinimumAgeDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumAgeDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the minimum number of days until a user can change their password
     * again.”</i>
     * 
     * @param passwordMinimumAgeDays
     *            new value of {@code passwordMinimumAgeDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumAgeDays} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordMinimumAgeDays(Integer passwordMinimumAgeDays) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordMinimumAgeDays = passwordMinimumAgeDays;
        return _x;
    }

    /**
     * <i>“Gets or sets the minimum length of a password.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the minimum length of a password.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordMinimumLength(Integer passwordMinimumLength) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Gets or sets the number of previous passwords to block.”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the number of previous passwords to block.”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Enables or disables whether passwords must meet Active Directory's complexity
     * requirements.”</i>
     * 
     * @return property passwordRequireActiveDirectoryComplexity
     */
    @Property(name="passwordRequireActiveDirectoryComplexity")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequireActiveDirectoryComplexity() {
        return Optional.ofNullable(passwordRequireActiveDirectoryComplexity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequireActiveDirectoryComplexity} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables whether passwords must meet Active Directory's complexity
     * requirements.”</i>
     * 
     * @param passwordRequireActiveDirectoryComplexity
     *            new value of {@code passwordRequireActiveDirectoryComplexity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequireActiveDirectoryComplexity} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordRequireActiveDirectoryComplexity(Boolean passwordRequireActiveDirectoryComplexity) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
        return _x;
    }

    /**
     * <i>“Gets or sets a description of the password complexity requirements.”</i>
     * 
     * @return property passwordRequirementsDescription
     */
    @Property(name="passwordRequirementsDescription")
    @JsonIgnore
    public Optional<String> getPasswordRequirementsDescription() {
        return Optional.ofNullable(passwordRequirementsDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequirementsDescription} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a description of the password complexity requirements.”</i>
     * 
     * @param passwordRequirementsDescription
     *            new value of {@code passwordRequirementsDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequirementsDescription} field changed
     */
    public IosKerberosSingleSignOnExtension withPasswordRequirementsDescription(String passwordRequirementsDescription) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.passwordRequirementsDescription = passwordRequirementsDescription;
        return _x;
    }

    /**
     * <i>“Gets or sets the case-sensitive realm name for this profile.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the case-sensitive realm name for this profile.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public IosKerberosSingleSignOnExtension withRealm(String realm) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“Gets or sets whether to require authentication via Touch ID, Face ID, or a
     * passcode to access the keychain entry.”</i>
     * 
     * @return property requireUserPresence
     */
    @Property(name="requireUserPresence")
    @JsonIgnore
    public Optional<Boolean> getRequireUserPresence() {
        return Optional.ofNullable(requireUserPresence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireUserPresence} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets whether to require authentication via Touch ID, Face ID, or a
     * passcode to access the keychain entry.”</i>
     * 
     * @param requireUserPresence
     *            new value of {@code requireUserPresence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireUserPresence} field changed
     */
    public IosKerberosSingleSignOnExtension withRequireUserPresence(Boolean requireUserPresence) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.requireUserPresence = requireUserPresence;
        return _x;
    }

    /**
     * <i>“Text displayed to the user at the Kerberos sign in window. Available for devices
     * running iOS and iPadOS versions 14 and later.”</i>
     * 
     * @return property signInHelpText
     */
    @Property(name="signInHelpText")
    @JsonIgnore
    public Optional<String> getSignInHelpText() {
        return Optional.ofNullable(signInHelpText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code signInHelpText}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Text displayed to the user at the Kerberos sign in window. Available for devices
     * running iOS and iPadOS versions 14 and later.”</i>
     * 
     * @param signInHelpText
     *            new value of {@code signInHelpText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signInHelpText} field changed
     */
    public IosKerberosSingleSignOnExtension withSignInHelpText(String signInHelpText) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.signInHelpText = signInHelpText;
        return _x;
    }

    /**
     * <i>“Gets or sets the principle user name to use for this profile. The realm name
     * does not need to be included.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the principle user name to use for this profile. The realm name
     * does not need to be included.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public IosKerberosSingleSignOnExtension withUserPrincipalName(String userPrincipalName) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosKerberosSingleSignOnExtension");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public IosKerberosSingleSignOnExtension withUnmappedField(String name, Object value) {
        IosKerberosSingleSignOnExtension _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosKerberosSingleSignOnExtension() {
        return new Builder();
    }

    public static final class Builder {
        private String activeDirectorySiteCode;
        private Boolean blockActiveDirectorySiteAutoDiscovery;
        private Boolean blockAutomaticLogin;
        private String cacheName;
        private List<String> credentialBundleIdAccessControlList;
        private String credentialBundleIdAccessControlListNextLink;
        private List<String> domainRealms;
        private String domainRealmsNextLink;
        private List<String> domains;
        private String domainsNextLink;
        private Boolean isDefaultRealm;
        private Boolean managedAppsInBundleIdACLIncluded;
        private Boolean passwordBlockModification;
        private String passwordChangeUrl;
        private Boolean passwordEnableLocalSync;
        private Integer passwordExpirationDays;
        private Integer passwordExpirationNotificationDays;
        private Integer passwordMinimumAgeDays;
        private Integer passwordMinimumLength;
        private Integer passwordPreviousPasswordBlockCount;
        private Boolean passwordRequireActiveDirectoryComplexity;
        private String passwordRequirementsDescription;
        private String realm;
        private Boolean requireUserPresence;
        private String signInHelpText;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Gets or sets the Active Directory site.”</i>
         * 
         * @param activeDirectorySiteCode
         *            value of {@code activeDirectorySiteCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeDirectorySiteCode(String activeDirectorySiteCode) {
            this.activeDirectorySiteCode = activeDirectorySiteCode;
            this.changedFields = changedFields.add("activeDirectorySiteCode");
            return this;
        }

        /**
         * <i>“Enables or disables whether the Kerberos extension can automatically determine
         * its site name.”</i>
         * 
         * @param blockActiveDirectorySiteAutoDiscovery
         *            value of {@code blockActiveDirectorySiteAutoDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockActiveDirectorySiteAutoDiscovery(Boolean blockActiveDirectorySiteAutoDiscovery) {
            this.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
            this.changedFields = changedFields.add("blockActiveDirectorySiteAutoDiscovery");
            return this;
        }

        /**
         * <i>“Enables or disables Keychain usage.”</i>
         * 
         * @param blockAutomaticLogin
         *            value of {@code blockAutomaticLogin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockAutomaticLogin(Boolean blockAutomaticLogin) {
            this.blockAutomaticLogin = blockAutomaticLogin;
            this.changedFields = changedFields.add("blockAutomaticLogin");
            return this;
        }

        /**
         * <i>“Gets or sets the Generic Security Services name of the Kerberos cache to use for
         * this profile.”</i>
         * 
         * @param cacheName
         *            value of {@code cacheName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheName(String cacheName) {
            this.cacheName = cacheName;
            this.changedFields = changedFields.add("cacheName");
            return this;
        }

        /**
         * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
         * Granting Ticket.”</i>
         * 
         * @param credentialBundleIdAccessControlList
         *            value of {@code credentialBundleIdAccessControlList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder credentialBundleIdAccessControlList(List<String> credentialBundleIdAccessControlList) {
            this.credentialBundleIdAccessControlList = credentialBundleIdAccessControlList;
            this.changedFields = changedFields.add("credentialBundleIdAccessControlList");
            return this;
        }

        /**
         * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
         * Granting Ticket.”</i>
         * 
         * @param credentialBundleIdAccessControlList
         *            value of {@code credentialBundleIdAccessControlList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder credentialBundleIdAccessControlList(String... credentialBundleIdAccessControlList) {
            return credentialBundleIdAccessControlList(Arrays.asList(credentialBundleIdAccessControlList));
        }

        /**
         * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
         * Granting Ticket.”</i>
         * 
         * @param credentialBundleIdAccessControlListNextLink
         *            value of {@code credentialBundleIdAccessControlList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder credentialBundleIdAccessControlListNextLink(String credentialBundleIdAccessControlListNextLink) {
            this.credentialBundleIdAccessControlListNextLink = credentialBundleIdAccessControlListNextLink;
            this.changedFields = changedFields.add("credentialBundleIdAccessControlList");
            return this;
        }

        /**
         * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
         * sensitive.”</i>
         * 
         * @param domainRealms
         *            value of {@code domainRealms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainRealms(List<String> domainRealms) {
            this.domainRealms = domainRealms;
            this.changedFields = changedFields.add("domainRealms");
            return this;
        }

        /**
         * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
         * sensitive.”</i>
         * 
         * @param domainRealms
         *            value of {@code domainRealms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainRealms(String... domainRealms) {
            return domainRealms(Arrays.asList(domainRealms));
        }

        /**
         * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
         * sensitive.”</i>
         * 
         * @param domainRealmsNextLink
         *            value of {@code domainRealms@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainRealmsNextLink(String domainRealmsNextLink) {
            this.domainRealmsNextLink = domainRealmsNextLink;
            this.changedFields = changedFields.add("domainRealms");
            return this;
        }

        /**
         * <i>“Gets or sets a list of hosts or domain names for which the app extension
         * performs SSO.”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(List<String> domains) {
            this.domains = domains;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        /**
         * <i>“Gets or sets a list of hosts or domain names for which the app extension
         * performs SSO.”</i>
         * 
         * @param domains
         *            value of {@code domains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domains(String... domains) {
            return domains(Arrays.asList(domains));
        }

        /**
         * <i>“Gets or sets a list of hosts or domain names for which the app extension
         * performs SSO.”</i>
         * 
         * @param domainsNextLink
         *            value of {@code domains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder domainsNextLink(String domainsNextLink) {
            this.domainsNextLink = domainsNextLink;
            this.changedFields = changedFields.add("domains");
            return this;
        }

        /**
         * <i>“When true, this profile's realm will be selected as the default. Necessary if
         * multiple Kerberos-type profiles are configured.”</i>
         * 
         * @param isDefaultRealm
         *            value of {@code isDefaultRealm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDefaultRealm(Boolean isDefaultRealm) {
            this.isDefaultRealm = isDefaultRealm;
            this.changedFields = changedFields.add("isDefaultRealm");
            return this;
        }

        /**
         * <i>“When set to True, the Kerberos extension allows managed apps, and any apps
         * entered with the app bundle ID to access the credential. When set to False, the
         * Kerberos extension allows all apps to access the credential. Available for
         * devices running iOS and iPadOS versions 14 and later.”</i>
         * 
         * @param managedAppsInBundleIdACLIncluded
         *            value of {@code managedAppsInBundleIdACLIncluded} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppsInBundleIdACLIncluded(Boolean managedAppsInBundleIdACLIncluded) {
            this.managedAppsInBundleIdACLIncluded = managedAppsInBundleIdACLIncluded;
            this.changedFields = changedFields.add("managedAppsInBundleIdACLIncluded");
            return this;
        }

        /**
         * <i>“Enables or disables password changes.”</i>
         * 
         * @param passwordBlockModification
         *            value of {@code passwordBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockModification(Boolean passwordBlockModification) {
            this.passwordBlockModification = passwordBlockModification;
            this.changedFields = changedFields.add("passwordBlockModification");
            return this;
        }

        /**
         * <i>“Gets or sets the URL that the user will be sent to when they initiate a password
         * change.”</i>
         * 
         * @param passwordChangeUrl
         *            value of {@code passwordChangeUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordChangeUrl(String passwordChangeUrl) {
            this.passwordChangeUrl = passwordChangeUrl;
            this.changedFields = changedFields.add("passwordChangeUrl");
            return this;
        }

        /**
         * <i>“Enables or disables password syncing. This won't affect users logged in with a
         * mobile account on macOS.”</i>
         * 
         * @param passwordEnableLocalSync
         *            value of {@code passwordEnableLocalSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordEnableLocalSync(Boolean passwordEnableLocalSync) {
            this.passwordEnableLocalSync = passwordEnableLocalSync;
            this.changedFields = changedFields.add("passwordEnableLocalSync");
            return this;
        }

        /**
         * <i>“Overrides the default password expiration in days. For most domains, this value
         * is calculated automatically.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Gets or sets the number of days until the user is notified that their password
         * will expire (default is 15).”</i>
         * 
         * @param passwordExpirationNotificationDays
         *            value of {@code passwordExpirationNotificationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationNotificationDays(Integer passwordExpirationNotificationDays) {
            this.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
            this.changedFields = changedFields.add("passwordExpirationNotificationDays");
            return this;
        }

        /**
         * <i>“Gets or sets the minimum number of days until a user can change their password
         * again.”</i>
         * 
         * @param passwordMinimumAgeDays
         *            value of {@code passwordMinimumAgeDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumAgeDays(Integer passwordMinimumAgeDays) {
            this.passwordMinimumAgeDays = passwordMinimumAgeDays;
            this.changedFields = changedFields.add("passwordMinimumAgeDays");
            return this;
        }

        /**
         * <i>“Gets or sets the minimum length of a password.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Gets or sets the number of previous passwords to block.”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Enables or disables whether passwords must meet Active Directory's complexity
         * requirements.”</i>
         * 
         * @param passwordRequireActiveDirectoryComplexity
         *            value of {@code passwordRequireActiveDirectoryComplexity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequireActiveDirectoryComplexity(Boolean passwordRequireActiveDirectoryComplexity) {
            this.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
            this.changedFields = changedFields.add("passwordRequireActiveDirectoryComplexity");
            return this;
        }

        /**
         * <i>“Gets or sets a description of the password complexity requirements.”</i>
         * 
         * @param passwordRequirementsDescription
         *            value of {@code passwordRequirementsDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequirementsDescription(String passwordRequirementsDescription) {
            this.passwordRequirementsDescription = passwordRequirementsDescription;
            this.changedFields = changedFields.add("passwordRequirementsDescription");
            return this;
        }

        /**
         * <i>“Gets or sets the case-sensitive realm name for this profile.”</i>
         * 
         * @param realm
         *            value of {@code realm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        /**
         * <i>“Gets or sets whether to require authentication via Touch ID, Face ID, or a
         * passcode to access the keychain entry.”</i>
         * 
         * @param requireUserPresence
         *            value of {@code requireUserPresence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireUserPresence(Boolean requireUserPresence) {
            this.requireUserPresence = requireUserPresence;
            this.changedFields = changedFields.add("requireUserPresence");
            return this;
        }

        /**
         * <i>“Text displayed to the user at the Kerberos sign in window. Available for devices
         * running iOS and iPadOS versions 14 and later.”</i>
         * 
         * @param signInHelpText
         *            value of {@code signInHelpText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signInHelpText(String signInHelpText) {
            this.signInHelpText = signInHelpText;
            this.changedFields = changedFields.add("signInHelpText");
            return this;
        }

        /**
         * <i>“Gets or sets the principle user name to use for this profile. The realm name
         * does not need to be included.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public IosKerberosSingleSignOnExtension build() {
            IosKerberosSingleSignOnExtension _x = new IosKerberosSingleSignOnExtension();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosKerberosSingleSignOnExtension";
            _x.activeDirectorySiteCode = activeDirectorySiteCode;
            _x.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
            _x.blockAutomaticLogin = blockAutomaticLogin;
            _x.cacheName = cacheName;
            _x.credentialBundleIdAccessControlList = credentialBundleIdAccessControlList;
            _x.credentialBundleIdAccessControlListNextLink = credentialBundleIdAccessControlListNextLink;
            _x.domainRealms = domainRealms;
            _x.domainRealmsNextLink = domainRealmsNextLink;
            _x.domains = domains;
            _x.domainsNextLink = domainsNextLink;
            _x.isDefaultRealm = isDefaultRealm;
            _x.managedAppsInBundleIdACLIncluded = managedAppsInBundleIdACLIncluded;
            _x.passwordBlockModification = passwordBlockModification;
            _x.passwordChangeUrl = passwordChangeUrl;
            _x.passwordEnableLocalSync = passwordEnableLocalSync;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
            _x.passwordMinimumAgeDays = passwordMinimumAgeDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
            _x.passwordRequirementsDescription = passwordRequirementsDescription;
            _x.realm = realm;
            _x.requireUserPresence = requireUserPresence;
            _x.signInHelpText = signInHelpText;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private IosKerberosSingleSignOnExtension _copy() {
        IosKerberosSingleSignOnExtension _x = new IosKerberosSingleSignOnExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.activeDirectorySiteCode = activeDirectorySiteCode;
        _x.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
        _x.blockAutomaticLogin = blockAutomaticLogin;
        _x.cacheName = cacheName;
        _x.credentialBundleIdAccessControlList = credentialBundleIdAccessControlList;
        _x.domainRealms = domainRealms;
        _x.domains = domains;
        _x.isDefaultRealm = isDefaultRealm;
        _x.managedAppsInBundleIdACLIncluded = managedAppsInBundleIdACLIncluded;
        _x.passwordBlockModification = passwordBlockModification;
        _x.passwordChangeUrl = passwordChangeUrl;
        _x.passwordEnableLocalSync = passwordEnableLocalSync;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
        _x.passwordMinimumAgeDays = passwordMinimumAgeDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
        _x.passwordRequirementsDescription = passwordRequirementsDescription;
        _x.realm = realm;
        _x.requireUserPresence = requireUserPresence;
        _x.signInHelpText = signInHelpText;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosKerberosSingleSignOnExtension[");
        b.append("activeDirectorySiteCode=");
        b.append(this.activeDirectorySiteCode);
        b.append(", ");
        b.append("blockActiveDirectorySiteAutoDiscovery=");
        b.append(this.blockActiveDirectorySiteAutoDiscovery);
        b.append(", ");
        b.append("blockAutomaticLogin=");
        b.append(this.blockAutomaticLogin);
        b.append(", ");
        b.append("cacheName=");
        b.append(this.cacheName);
        b.append(", ");
        b.append("credentialBundleIdAccessControlList=");
        b.append(this.credentialBundleIdAccessControlList);
        b.append(", ");
        b.append("domainRealms=");
        b.append(this.domainRealms);
        b.append(", ");
        b.append("domains=");
        b.append(this.domains);
        b.append(", ");
        b.append("isDefaultRealm=");
        b.append(this.isDefaultRealm);
        b.append(", ");
        b.append("managedAppsInBundleIdACLIncluded=");
        b.append(this.managedAppsInBundleIdACLIncluded);
        b.append(", ");
        b.append("passwordBlockModification=");
        b.append(this.passwordBlockModification);
        b.append(", ");
        b.append("passwordChangeUrl=");
        b.append(this.passwordChangeUrl);
        b.append(", ");
        b.append("passwordEnableLocalSync=");
        b.append(this.passwordEnableLocalSync);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordExpirationNotificationDays=");
        b.append(this.passwordExpirationNotificationDays);
        b.append(", ");
        b.append("passwordMinimumAgeDays=");
        b.append(this.passwordMinimumAgeDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequireActiveDirectoryComplexity=");
        b.append(this.passwordRequireActiveDirectoryComplexity);
        b.append(", ");
        b.append("passwordRequirementsDescription=");
        b.append(this.passwordRequirementsDescription);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("requireUserPresence=");
        b.append(this.requireUserPresence);
        b.append(", ");
        b.append("signInHelpText=");
        b.append(this.signInHelpText);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
