package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A page containing apps, folders, and web clips on the Home Screen.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "icons"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenPage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("icons")
    protected List<IosHomeScreenItem> icons;

    @JsonProperty("icons@nextLink")
    protected String iconsNextLink;

    protected IosHomeScreenPage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenPage";
    }

    /**
     * <i>“Name of the page”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the page”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosHomeScreenPage withDisplayName(String displayName) {
        IosHomeScreenPage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenPage");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“A list of apps, folders, and web clips to appear on a page. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property icons
     */
    @Property(name="icons")
    @JsonIgnore
    public CollectionPage<IosHomeScreenItem> getIcons() {
        return new CollectionPage<IosHomeScreenItem>(contextPath, IosHomeScreenItem.class, this.icons, Optional.ofNullable(iconsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of apps, folders, and web clips to appear on a page. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property icons
     */
    @Property(name="icons")
    @JsonIgnore
    public CollectionPage<IosHomeScreenItem> getIcons(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenItem>(contextPath, IosHomeScreenItem.class, this.icons, Optional.ofNullable(iconsNextLink), Collections.emptyList(), options);
    }

    public IosHomeScreenPage withUnmappedField(String name, Object value) {
        IosHomeScreenPage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<IosHomeScreenItem> icons;
        private String iconsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the page”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“A list of apps, folders, and web clips to appear on a page. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param icons
         *            value of {@code icons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder icons(List<IosHomeScreenItem> icons) {
            this.icons = icons;
            this.changedFields = changedFields.add("icons");
            return this;
        }

        /**
         * <i>“A list of apps, folders, and web clips to appear on a page. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param icons
         *            value of {@code icons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder icons(IosHomeScreenItem... icons) {
            return icons(Arrays.asList(icons));
        }

        /**
         * <i>“A list of apps, folders, and web clips to appear on a page. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param iconsNextLink
         *            value of {@code icons@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iconsNextLink(String iconsNextLink) {
            this.iconsNextLink = iconsNextLink;
            this.changedFields = changedFields.add("icons");
            return this;
        }

        public IosHomeScreenPage build() {
            IosHomeScreenPage _x = new IosHomeScreenPage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosHomeScreenPage";
            _x.displayName = displayName;
            _x.icons = icons;
            _x.iconsNextLink = iconsNextLink;
            return _x;
        }
    }

    private IosHomeScreenPage _copy() {
        IosHomeScreenPage _x = new IosHomeScreenPage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.icons = icons;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenPage[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("icons=");
        b.append(this.icons);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
