package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;


/**
 * <i>“Trusted Root and PFX certificates for iOS EDU.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certFileName", 
    "certificateTemplateName", 
    "certificateValidityPeriodScale", 
    "certificateValidityPeriodValue", 
    "certificationAuthority", 
    "certificationAuthorityName", 
    "renewalThresholdPercentage", 
    "trustedRootCertificate"})
@JsonInclude(Include.NON_NULL)
public class IosEduCertificateSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certFileName")
    protected String certFileName;

    @JsonProperty("certificateTemplateName")
    protected String certificateTemplateName;

    @JsonProperty("certificateValidityPeriodScale")
    protected CertificateValidityPeriodScale certificateValidityPeriodScale;

    @JsonProperty("certificateValidityPeriodValue")
    protected Integer certificateValidityPeriodValue;

    @JsonProperty("certificationAuthority")
    protected String certificationAuthority;

    @JsonProperty("certificationAuthorityName")
    protected String certificationAuthorityName;

    @JsonProperty("renewalThresholdPercentage")
    protected Integer renewalThresholdPercentage;

    @JsonProperty("trustedRootCertificate")
    protected byte[] trustedRootCertificate;

    protected IosEduCertificateSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosEduCertificateSettings";
    }

    /**
     * <i>“File name to display in UI.”</i>
     * 
     * @return property certFileName
     */
    @Property(name="certFileName")
    @JsonIgnore
    public Optional<String> getCertFileName() {
        return Optional.ofNullable(certFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certFileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“File name to display in UI.”</i>
     * 
     * @param certFileName
     *            new value of {@code certFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certFileName} field changed
     */
    public IosEduCertificateSettings withCertFileName(String certFileName) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certFileName = certFileName;
        return _x;
    }

    /**
     * <i>“PKCS Certificate Template Name.”</i>
     * 
     * @return property certificateTemplateName
     */
    @Property(name="certificateTemplateName")
    @JsonIgnore
    public Optional<String> getCertificateTemplateName() {
        return Optional.ofNullable(certificateTemplateName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateTemplateName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certificate Template Name.”</i>
     * 
     * @param certificateTemplateName
     *            new value of {@code certificateTemplateName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateTemplateName} field changed
     */
    public IosEduCertificateSettings withCertificateTemplateName(String certificateTemplateName) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certificateTemplateName = certificateTemplateName;
        return _x;
    }

    /**
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @return property certificateValidityPeriodScale
     */
    @Property(name="certificateValidityPeriodScale")
    @JsonIgnore
    public Optional<CertificateValidityPeriodScale> getCertificateValidityPeriodScale() {
        return Optional.ofNullable(certificateValidityPeriodScale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodScale} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Scale for the Certificate Validity Period.”</i>
     * 
     * @param certificateValidityPeriodScale
     *            new value of {@code certificateValidityPeriodScale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodScale} field changed
     */
    public IosEduCertificateSettings withCertificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        return _x;
    }

    /**
     * <i>“Value for the Certificate Validity Period.”</i>
     * 
     * @return property certificateValidityPeriodValue
     */
    @Property(name="certificateValidityPeriodValue")
    @JsonIgnore
    public Optional<Integer> getCertificateValidityPeriodValue() {
        return Optional.ofNullable(certificateValidityPeriodValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value for the Certificate Validity Period.”</i>
     * 
     * @param certificateValidityPeriodValue
     *            new value of {@code certificateValidityPeriodValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodValue} field changed
     */
    public IosEduCertificateSettings withCertificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        return _x;
    }

    /**
     * <i>“PKCS Certification Authority.”</i>
     * 
     * @return property certificationAuthority
     */
    @Property(name="certificationAuthority")
    @JsonIgnore
    public Optional<String> getCertificationAuthority() {
        return Optional.ofNullable(certificationAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthority} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority.”</i>
     * 
     * @param certificationAuthority
     *            new value of {@code certificationAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthority} field changed
     */
    public IosEduCertificateSettings withCertificationAuthority(String certificationAuthority) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certificationAuthority = certificationAuthority;
        return _x;
    }

    /**
     * <i>“PKCS Certification Authority Name.”</i>
     * 
     * @return property certificationAuthorityName
     */
    @Property(name="certificationAuthorityName")
    @JsonIgnore
    public Optional<String> getCertificationAuthorityName() {
        return Optional.ofNullable(certificationAuthorityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthorityName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority Name.”</i>
     * 
     * @param certificationAuthorityName
     *            new value of {@code certificationAuthorityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthorityName} field changed
     */
    public IosEduCertificateSettings withCertificationAuthorityName(String certificationAuthorityName) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.certificationAuthorityName = certificationAuthorityName;
        return _x;
    }

    /**
     * <i>“Certificate renewal threshold percentage. Valid values 1 to 99”</i>
     * 
     * @return property renewalThresholdPercentage
     */
    @Property(name="renewalThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getRenewalThresholdPercentage() {
        return Optional.ofNullable(renewalThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * renewalThresholdPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate renewal threshold percentage. Valid values 1 to 99”</i>
     * 
     * @param renewalThresholdPercentage
     *            new value of {@code renewalThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code renewalThresholdPercentage} field changed
     */
    public IosEduCertificateSettings withRenewalThresholdPercentage(Integer renewalThresholdPercentage) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificate.”</i>
     * 
     * @return property trustedRootCertificate
     */
    @Property(name="trustedRootCertificate")
    @JsonIgnore
    public Optional<byte[]> getTrustedRootCertificate() {
        return Optional.ofNullable(trustedRootCertificate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trustedRootCertificate} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Trusted Root Certificate.”</i>
     * 
     * @param trustedRootCertificate
     *            new value of {@code trustedRootCertificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trustedRootCertificate} field changed
     */
    public IosEduCertificateSettings withTrustedRootCertificate(byte[] trustedRootCertificate) {
        IosEduCertificateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosEduCertificateSettings");
        _x.trustedRootCertificate = trustedRootCertificate;
        return _x;
    }

    public IosEduCertificateSettings withUnmappedField(String name, Object value) {
        IosEduCertificateSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String certFileName;
        private String certificateTemplateName;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private Integer certificateValidityPeriodValue;
        private String certificationAuthority;
        private String certificationAuthorityName;
        private Integer renewalThresholdPercentage;
        private byte[] trustedRootCertificate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“File name to display in UI.”</i>
         * 
         * @param certFileName
         *            value of {@code certFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certFileName(String certFileName) {
            this.certFileName = certFileName;
            this.changedFields = changedFields.add("certFileName");
            return this;
        }

        /**
         * <i>“PKCS Certificate Template Name.”</i>
         * 
         * @param certificateTemplateName
         *            value of {@code certificateTemplateName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateTemplateName(String certificateTemplateName) {
            this.certificateTemplateName = certificateTemplateName;
            this.changedFields = changedFields.add("certificateTemplateName");
            return this;
        }

        /**
         * <i>“Scale for the Certificate Validity Period.”</i>
         * 
         * @param certificateValidityPeriodScale
         *            value of {@code certificateValidityPeriodScale} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        /**
         * <i>“Value for the Certificate Validity Period.”</i>
         * 
         * @param certificateValidityPeriodValue
         *            value of {@code certificateValidityPeriodValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority.”</i>
         * 
         * @param certificationAuthority
         *            value of {@code certificationAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthority(String certificationAuthority) {
            this.certificationAuthority = certificationAuthority;
            this.changedFields = changedFields.add("certificationAuthority");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority Name.”</i>
         * 
         * @param certificationAuthorityName
         *            value of {@code certificationAuthorityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthorityName(String certificationAuthorityName) {
            this.certificationAuthorityName = certificationAuthorityName;
            this.changedFields = changedFields.add("certificationAuthorityName");
            return this;
        }

        /**
         * <i>“Certificate renewal threshold percentage. Valid values 1 to 99”</i>
         * 
         * @param renewalThresholdPercentage
         *            value of {@code renewalThresholdPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        /**
         * <i>“Trusted Root Certificate.”</i>
         * 
         * @param trustedRootCertificate
         *            value of {@code trustedRootCertificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedRootCertificate(byte[] trustedRootCertificate) {
            this.trustedRootCertificate = trustedRootCertificate;
            this.changedFields = changedFields.add("trustedRootCertificate");
            return this;
        }

        public IosEduCertificateSettings build() {
            IosEduCertificateSettings _x = new IosEduCertificateSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosEduCertificateSettings";
            _x.certFileName = certFileName;
            _x.certificateTemplateName = certificateTemplateName;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.certificationAuthority = certificationAuthority;
            _x.certificationAuthorityName = certificationAuthorityName;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.trustedRootCertificate = trustedRootCertificate;
            return _x;
        }
    }

    private IosEduCertificateSettings _copy() {
        IosEduCertificateSettings _x = new IosEduCertificateSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certFileName = certFileName;
        _x.certificateTemplateName = certificateTemplateName;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.certificationAuthority = certificationAuthority;
        _x.certificationAuthorityName = certificationAuthorityName;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.trustedRootCertificate = trustedRootCertificate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosEduCertificateSettings[");
        b.append("certFileName=");
        b.append(this.certFileName);
        b.append(", ");
        b.append("certificateTemplateName=");
        b.append(this.certificateTemplateName);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("certificationAuthority=");
        b.append(this.certificationAuthority);
        b.append(", ");
        b.append("certificationAuthorityName=");
        b.append(this.certificationAuthorityName);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("trustedRootCertificate=");
        b.append(this.trustedRootCertificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
