package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties of the possible iOS device types the mobile app can run on.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "iPad", 
    "iPhoneAndIPod"})
@JsonInclude(Include.NON_NULL)
public class IosDeviceType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("iPad")
    protected Boolean iPad;

    @JsonProperty("iPhoneAndIPod")
    protected Boolean iPhoneAndIPod;

    protected IosDeviceType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosDeviceType";
    }

    /**
     * <i>“Whether the app should run on iPads.”</i>
     * 
     * @return property iPad
     */
    @Property(name="iPad")
    @JsonIgnore
    public Optional<Boolean> getIPad() {
        return Optional.ofNullable(iPad);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iPad} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether the app should run on iPads.”</i>
     * 
     * @param iPad
     *            new value of {@code iPad} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iPad} field changed
     */
    public IosDeviceType withIPad(Boolean iPad) {
        IosDeviceType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceType");
        _x.iPad = iPad;
        return _x;
    }

    /**
     * <i>“Whether the app should run on iPhones and iPods.”</i>
     * 
     * @return property iPhoneAndIPod
     */
    @Property(name="iPhoneAndIPod")
    @JsonIgnore
    public Optional<Boolean> getIPhoneAndIPod() {
        return Optional.ofNullable(iPhoneAndIPod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iPhoneAndIPod}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the app should run on iPhones and iPods.”</i>
     * 
     * @param iPhoneAndIPod
     *            new value of {@code iPhoneAndIPod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iPhoneAndIPod} field changed
     */
    public IosDeviceType withIPhoneAndIPod(Boolean iPhoneAndIPod) {
        IosDeviceType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosDeviceType");
        _x.iPhoneAndIPod = iPhoneAndIPod;
        return _x;
    }

    public IosDeviceType withUnmappedField(String name, Object value) {
        IosDeviceType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean iPad;
        private Boolean iPhoneAndIPod;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether the app should run on iPads.”</i>
         * 
         * @param iPad
         *            value of {@code iPad} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iPad(Boolean iPad) {
            this.iPad = iPad;
            this.changedFields = changedFields.add("iPad");
            return this;
        }

        /**
         * <i>“Whether the app should run on iPhones and iPods.”</i>
         * 
         * @param iPhoneAndIPod
         *            value of {@code iPhoneAndIPod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iPhoneAndIPod(Boolean iPhoneAndIPod) {
            this.iPhoneAndIPod = iPhoneAndIPod;
            this.changedFields = changedFields.add("iPhoneAndIPod");
            return this;
        }

        public IosDeviceType build() {
            IosDeviceType _x = new IosDeviceType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosDeviceType";
            _x.iPad = iPad;
            _x.iPhoneAndIPod = iPhoneAndIPod;
            return _x;
        }
    }

    private IosDeviceType _copy() {
        IosDeviceType _x = new IosDeviceType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.iPad = iPad;
        _x.iPhoneAndIPod = iPhoneAndIPod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosDeviceType[");
        b.append("iPad=");
        b.append(this.iPad);
        b.append(", ");
        b.append("iPhoneAndIPod=");
        b.append(this.iPhoneAndIPod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
