package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“iOS URL bookmark”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bookmarkFolder", 
    "displayName", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class IosBookmark implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bookmarkFolder")
    protected String bookmarkFolder;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("url")
    protected String url;

    protected IosBookmark() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosBookmark";
    }

    /**
     * <i>“The folder into which the bookmark should be added in Safari”</i>
     * 
     * @return property bookmarkFolder
     */
    @Property(name="bookmarkFolder")
    @JsonIgnore
    public Optional<String> getBookmarkFolder() {
        return Optional.ofNullable(bookmarkFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bookmarkFolder}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The folder into which the bookmark should be added in Safari”</i>
     * 
     * @param bookmarkFolder
     *            new value of {@code bookmarkFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bookmarkFolder} field changed
     */
    public IosBookmark withBookmarkFolder(String bookmarkFolder) {
        IosBookmark _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosBookmark");
        _x.bookmarkFolder = bookmarkFolder;
        return _x;
    }

    /**
     * <i>“The display name of the bookmark”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the bookmark”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosBookmark withDisplayName(String displayName) {
        IosBookmark _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosBookmark");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“URL allowed to access”</i>
     * 
     * @return property url
     */
    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code url} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“URL allowed to access”</i>
     * 
     * @param url
     *            new value of {@code url} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code url} field changed
     */
    public IosBookmark withUrl(String url) {
        IosBookmark _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosBookmark");
        _x.url = url;
        return _x;
    }

    public IosBookmark withUnmappedField(String name, Object value) {
        IosBookmark _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bookmarkFolder;
        private String displayName;
        private String url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The folder into which the bookmark should be added in Safari”</i>
         * 
         * @param bookmarkFolder
         *            value of {@code bookmarkFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bookmarkFolder(String bookmarkFolder) {
            this.bookmarkFolder = bookmarkFolder;
            this.changedFields = changedFields.add("bookmarkFolder");
            return this;
        }

        /**
         * <i>“The display name of the bookmark”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“URL allowed to access”</i>
         * 
         * @param url
         *            value of {@code url} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public IosBookmark build() {
            IosBookmark _x = new IosBookmark();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosBookmark";
            _x.bookmarkFolder = bookmarkFolder;
            _x.displayName = displayName;
            _x.url = url;
            return _x;
        }
    }

    private IosBookmark _copy() {
        IosBookmark _x = new IosBookmark();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bookmarkFolder = bookmarkFolder;
        _x.displayName = displayName;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosBookmark[");
        b.append("bookmarkFolder=");
        b.append(this.bookmarkFolder);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
