package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents an Azure AD-type Single Sign-On extension profile for iOS devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleIdAccessControlList", 
    "configurations", 
    "enableSharedDeviceMode"})
@JsonInclude(Include.NON_NULL)
public class IosAzureAdSingleSignOnExtension extends IosSingleSignOnExtension implements ODataType {

    @JsonProperty("bundleIdAccessControlList")
    protected List<String> bundleIdAccessControlList;

    @JsonProperty("bundleIdAccessControlList@nextLink")
    protected String bundleIdAccessControlListNextLink;

    @JsonProperty("configurations")
    protected List<KeyTypedValuePair> configurations;

    @JsonProperty("configurations@nextLink")
    protected String configurationsNextLink;

    @JsonProperty("enableSharedDeviceMode")
    protected Boolean enableSharedDeviceMode;

    protected IosAzureAdSingleSignOnExtension() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosAzureAdSingleSignOnExtension";
    }

    /**
     * <i>“An optional list of additional bundle IDs allowed to use the AAD extension for
     * single sign-on.”</i>
     * 
     * @return property bundleIdAccessControlList
     */
    @Property(name="bundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getBundleIdAccessControlList() {
        return new CollectionPage<String>(contextPath, String.class, this.bundleIdAccessControlList, Optional.ofNullable(bundleIdAccessControlListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“An optional list of additional bundle IDs allowed to use the AAD extension for
     * single sign-on.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property bundleIdAccessControlList
     */
    @Property(name="bundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getBundleIdAccessControlList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.bundleIdAccessControlList, Optional.ofNullable(bundleIdAccessControlListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
     * profiles. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property configurations
     */
    @Property(name="configurations")
    @JsonIgnore
    public CollectionPage<KeyTypedValuePair> getConfigurations() {
        return new CollectionPage<KeyTypedValuePair>(contextPath, KeyTypedValuePair.class, this.configurations, Optional.ofNullable(configurationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
     * profiles. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property configurations
     */
    @Property(name="configurations")
    @JsonIgnore
    public CollectionPage<KeyTypedValuePair> getConfigurations(HttpRequestOptions options) {
        return new CollectionPage<KeyTypedValuePair>(contextPath, KeyTypedValuePair.class, this.configurations, Optional.ofNullable(configurationsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Enables or disables shared device mode.”</i>
     * 
     * @return property enableSharedDeviceMode
     */
    @Property(name="enableSharedDeviceMode")
    @JsonIgnore
    public Optional<Boolean> getEnableSharedDeviceMode() {
        return Optional.ofNullable(enableSharedDeviceMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSharedDeviceMode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables shared device mode.”</i>
     * 
     * @param enableSharedDeviceMode
     *            new value of {@code enableSharedDeviceMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSharedDeviceMode} field changed
     */
    public IosAzureAdSingleSignOnExtension withEnableSharedDeviceMode(Boolean enableSharedDeviceMode) {
        IosAzureAdSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosAzureAdSingleSignOnExtension");
        _x.enableSharedDeviceMode = enableSharedDeviceMode;
        return _x;
    }

    public IosAzureAdSingleSignOnExtension withUnmappedField(String name, Object value) {
        IosAzureAdSingleSignOnExtension _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosAzureAdSingleSignOnExtension() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> bundleIdAccessControlList;
        private String bundleIdAccessControlListNextLink;
        private List<KeyTypedValuePair> configurations;
        private String configurationsNextLink;
        private Boolean enableSharedDeviceMode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“An optional list of additional bundle IDs allowed to use the AAD extension for
         * single sign-on.”</i>
         * 
         * @param bundleIdAccessControlList
         *            value of {@code bundleIdAccessControlList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleIdAccessControlList(List<String> bundleIdAccessControlList) {
            this.bundleIdAccessControlList = bundleIdAccessControlList;
            this.changedFields = changedFields.add("bundleIdAccessControlList");
            return this;
        }

        /**
         * <i>“An optional list of additional bundle IDs allowed to use the AAD extension for
         * single sign-on.”</i>
         * 
         * @param bundleIdAccessControlList
         *            value of {@code bundleIdAccessControlList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleIdAccessControlList(String... bundleIdAccessControlList) {
            return bundleIdAccessControlList(Arrays.asList(bundleIdAccessControlList));
        }

        /**
         * <i>“An optional list of additional bundle IDs allowed to use the AAD extension for
         * single sign-on.”</i>
         * 
         * @param bundleIdAccessControlListNextLink
         *            value of {@code bundleIdAccessControlList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleIdAccessControlListNextLink(String bundleIdAccessControlListNextLink) {
            this.bundleIdAccessControlListNextLink = bundleIdAccessControlListNextLink;
            this.changedFields = changedFields.add("bundleIdAccessControlList");
            return this;
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurations
         *            value of {@code configurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurations(List<KeyTypedValuePair> configurations) {
            this.configurations = configurations;
            this.changedFields = changedFields.add("configurations");
            return this;
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurations
         *            value of {@code configurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurations(KeyTypedValuePair... configurations) {
            return configurations(Arrays.asList(configurations));
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurationsNextLink
         *            value of {@code configurations@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationsNextLink(String configurationsNextLink) {
            this.configurationsNextLink = configurationsNextLink;
            this.changedFields = changedFields.add("configurations");
            return this;
        }

        /**
         * <i>“Enables or disables shared device mode.”</i>
         * 
         * @param enableSharedDeviceMode
         *            value of {@code enableSharedDeviceMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSharedDeviceMode(Boolean enableSharedDeviceMode) {
            this.enableSharedDeviceMode = enableSharedDeviceMode;
            this.changedFields = changedFields.add("enableSharedDeviceMode");
            return this;
        }

        public IosAzureAdSingleSignOnExtension build() {
            IosAzureAdSingleSignOnExtension _x = new IosAzureAdSingleSignOnExtension();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosAzureAdSingleSignOnExtension";
            _x.bundleIdAccessControlList = bundleIdAccessControlList;
            _x.bundleIdAccessControlListNextLink = bundleIdAccessControlListNextLink;
            _x.configurations = configurations;
            _x.configurationsNextLink = configurationsNextLink;
            _x.enableSharedDeviceMode = enableSharedDeviceMode;
            return _x;
        }
    }

    private IosAzureAdSingleSignOnExtension _copy() {
        IosAzureAdSingleSignOnExtension _x = new IosAzureAdSingleSignOnExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bundleIdAccessControlList = bundleIdAccessControlList;
        _x.configurations = configurations;
        _x.enableSharedDeviceMode = enableSharedDeviceMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosAzureAdSingleSignOnExtension[");
        b.append("bundleIdAccessControlList=");
        b.append(this.bundleIdAccessControlList);
        b.append(", ");
        b.append("configurations=");
        b.append(this.configurations);
        b.append(", ");
        b.append("enableSharedDeviceMode=");
        b.append(this.enableSharedDeviceMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
