package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ccRecipients", 
    "customizedMessageBody", 
    "messageLanguage"})
@JsonInclude(Include.NON_NULL)
public class InvitedUserMessageInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ccRecipients")
    protected List<Recipient> ccRecipients;

    @JsonProperty("ccRecipients@nextLink")
    protected String ccRecipientsNextLink;

    @JsonProperty("customizedMessageBody")
    protected String customizedMessageBody;

    @JsonProperty("messageLanguage")
    protected String messageLanguage;

    protected InvitedUserMessageInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.invitedUserMessageInfo";
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, this.ccRecipients, Optional.ofNullable(ccRecipientsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, this.ccRecipients, Optional.ofNullable(ccRecipientsNextLink), Collections.emptyList(), options);
    }

    @Property(name="customizedMessageBody")
    @JsonIgnore
    public Optional<String> getCustomizedMessageBody() {
        return Optional.ofNullable(customizedMessageBody);
    }

    public InvitedUserMessageInfo withCustomizedMessageBody(String customizedMessageBody) {
        InvitedUserMessageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitedUserMessageInfo");
        _x.customizedMessageBody = customizedMessageBody;
        return _x;
    }

    @Property(name="messageLanguage")
    @JsonIgnore
    public Optional<String> getMessageLanguage() {
        return Optional.ofNullable(messageLanguage);
    }

    public InvitedUserMessageInfo withMessageLanguage(String messageLanguage) {
        InvitedUserMessageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitedUserMessageInfo");
        _x.messageLanguage = messageLanguage;
        return _x;
    }

    public InvitedUserMessageInfo withUnmappedField(String name, Object value) {
        InvitedUserMessageInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Recipient> ccRecipients;
        private String ccRecipientsNextLink;
        private String customizedMessageBody;
        private String messageLanguage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ccRecipients(List<Recipient> ccRecipients) {
            this.ccRecipients = ccRecipients;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder ccRecipients(Recipient... ccRecipients) {
            return ccRecipients(Arrays.asList(ccRecipients));
        }

        public Builder ccRecipientsNextLink(String ccRecipientsNextLink) {
            this.ccRecipientsNextLink = ccRecipientsNextLink;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder customizedMessageBody(String customizedMessageBody) {
            this.customizedMessageBody = customizedMessageBody;
            this.changedFields = changedFields.add("customizedMessageBody");
            return this;
        }

        public Builder messageLanguage(String messageLanguage) {
            this.messageLanguage = messageLanguage;
            this.changedFields = changedFields.add("messageLanguage");
            return this;
        }

        public InvitedUserMessageInfo build() {
            InvitedUserMessageInfo _x = new InvitedUserMessageInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.invitedUserMessageInfo";
            _x.ccRecipients = ccRecipients;
            _x.ccRecipientsNextLink = ccRecipientsNextLink;
            _x.customizedMessageBody = customizedMessageBody;
            _x.messageLanguage = messageLanguage;
            return _x;
        }
    }

    private InvitedUserMessageInfo _copy() {
        InvitedUserMessageInfo _x = new InvitedUserMessageInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ccRecipients = ccRecipients;
        _x.customizedMessageBody = customizedMessageBody;
        _x.messageLanguage = messageLanguage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InvitedUserMessageInfo[");
        b.append("ccRecipients=");
        b.append(this.ccRecipients);
        b.append(", ");
        b.append("customizedMessageBody=");
        b.append(this.customizedMessageBody);
        b.append(", ");
        b.append("messageLanguage=");
        b.append(this.messageLanguage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
