package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EndpointType;

@JsonPropertyOrder({
    "@odata.type", 
    "endpointType", 
    "hidden", 
    "identity", 
    "participantId", 
    "removeFromDefaultAudioRoutingGroup", 
    "replacesCallId"})
@JsonInclude(Include.NON_NULL)
public class InvitationParticipantInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("endpointType")
    protected EndpointType endpointType;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("identity")
    protected IdentitySet identity;

    @JsonProperty("participantId")
    protected String participantId;

    @JsonProperty("removeFromDefaultAudioRoutingGroup")
    protected Boolean removeFromDefaultAudioRoutingGroup;

    @JsonProperty("replacesCallId")
    protected String replacesCallId;

    protected InvitationParticipantInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.invitationParticipantInfo";
    }

    @Property(name="endpointType")
    @JsonIgnore
    public Optional<EndpointType> getEndpointType() {
        return Optional.ofNullable(endpointType);
    }

    public InvitationParticipantInfo withEndpointType(EndpointType endpointType) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.endpointType = endpointType;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public InvitationParticipantInfo withHidden(Boolean hidden) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<IdentitySet> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public InvitationParticipantInfo withIdentity(IdentitySet identity) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.identity = identity;
        return _x;
    }

    @Property(name="participantId")
    @JsonIgnore
    public Optional<String> getParticipantId() {
        return Optional.ofNullable(participantId);
    }

    public InvitationParticipantInfo withParticipantId(String participantId) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.participantId = participantId;
        return _x;
    }

    @Property(name="removeFromDefaultAudioRoutingGroup")
    @JsonIgnore
    public Optional<Boolean> getRemoveFromDefaultAudioRoutingGroup() {
        return Optional.ofNullable(removeFromDefaultAudioRoutingGroup);
    }

    public InvitationParticipantInfo withRemoveFromDefaultAudioRoutingGroup(Boolean removeFromDefaultAudioRoutingGroup) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.removeFromDefaultAudioRoutingGroup = removeFromDefaultAudioRoutingGroup;
        return _x;
    }

    @Property(name="replacesCallId")
    @JsonIgnore
    public Optional<String> getReplacesCallId() {
        return Optional.ofNullable(replacesCallId);
    }

    public InvitationParticipantInfo withReplacesCallId(String replacesCallId) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.replacesCallId = replacesCallId;
        return _x;
    }

    public InvitationParticipantInfo withUnmappedField(String name, Object value) {
        InvitationParticipantInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EndpointType endpointType;
        private Boolean hidden;
        private IdentitySet identity;
        private String participantId;
        private Boolean removeFromDefaultAudioRoutingGroup;
        private String replacesCallId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder endpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
            this.changedFields = changedFields.add("endpointType");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder identity(IdentitySet identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder participantId(String participantId) {
            this.participantId = participantId;
            this.changedFields = changedFields.add("participantId");
            return this;
        }

        public Builder removeFromDefaultAudioRoutingGroup(Boolean removeFromDefaultAudioRoutingGroup) {
            this.removeFromDefaultAudioRoutingGroup = removeFromDefaultAudioRoutingGroup;
            this.changedFields = changedFields.add("removeFromDefaultAudioRoutingGroup");
            return this;
        }

        public Builder replacesCallId(String replacesCallId) {
            this.replacesCallId = replacesCallId;
            this.changedFields = changedFields.add("replacesCallId");
            return this;
        }

        public InvitationParticipantInfo build() {
            InvitationParticipantInfo _x = new InvitationParticipantInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.invitationParticipantInfo";
            _x.endpointType = endpointType;
            _x.hidden = hidden;
            _x.identity = identity;
            _x.participantId = participantId;
            _x.removeFromDefaultAudioRoutingGroup = removeFromDefaultAudioRoutingGroup;
            _x.replacesCallId = replacesCallId;
            return _x;
        }
    }

    private InvitationParticipantInfo _copy() {
        InvitationParticipantInfo _x = new InvitationParticipantInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endpointType = endpointType;
        _x.hidden = hidden;
        _x.identity = identity;
        _x.participantId = participantId;
        _x.removeFromDefaultAudioRoutingGroup = removeFromDefaultAudioRoutingGroup;
        _x.replacesCallId = replacesCallId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InvitationParticipantInfo[");
        b.append("endpointType=");
        b.append(this.endpointType);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("participantId=");
        b.append(this.participantId);
        b.append(", ");
        b.append("removeFromDefaultAudioRoutingGroup=");
        b.append(this.removeFromDefaultAudioRoutingGroup);
        b.append(", ");
        b.append("replacesCallId=");
        b.append(this.replacesCallId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
