package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "end", 
    "maximum", 
    "minimum", 
    "start"})
@JsonInclude(Include.NON_NULL)
public class IntegerRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("end")
    protected Long end;

    @JsonProperty("maximum")
    protected Long maximum;

    @JsonProperty("minimum")
    protected Long minimum;

    @JsonProperty("start")
    protected Long start;

    protected IntegerRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.integerRange";
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<Long> getEnd() {
        return Optional.ofNullable(end);
    }

    public IntegerRange withEnd(Long end) {
        IntegerRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.integerRange");
        _x.end = end;
        return _x;
    }

    @Property(name="maximum")
    @JsonIgnore
    public Optional<Long> getMaximum() {
        return Optional.ofNullable(maximum);
    }

    public IntegerRange withMaximum(Long maximum) {
        IntegerRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.integerRange");
        _x.maximum = maximum;
        return _x;
    }

    @Property(name="minimum")
    @JsonIgnore
    public Optional<Long> getMinimum() {
        return Optional.ofNullable(minimum);
    }

    public IntegerRange withMinimum(Long minimum) {
        IntegerRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.integerRange");
        _x.minimum = minimum;
        return _x;
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<Long> getStart() {
        return Optional.ofNullable(start);
    }

    public IntegerRange withStart(Long start) {
        IntegerRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.integerRange");
        _x.start = start;
        return _x;
    }

    public IntegerRange withUnmappedField(String name, Object value) {
        IntegerRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long end;
        private Long maximum;
        private Long minimum;
        private Long start;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder end(Long end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public Builder maximum(Long maximum) {
            this.maximum = maximum;
            this.changedFields = changedFields.add("maximum");
            return this;
        }

        public Builder minimum(Long minimum) {
            this.minimum = minimum;
            this.changedFields = changedFields.add("minimum");
            return this;
        }

        public Builder start(Long start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public IntegerRange build() {
            IntegerRange _x = new IntegerRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.integerRange";
            _x.end = end;
            _x.maximum = maximum;
            _x.minimum = minimum;
            _x.start = start;
            return _x;
        }
    }

    private IntegerRange _copy() {
        IntegerRange _x = new IntegerRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.end = end;
        _x.maximum = maximum;
        _x.minimum = minimum;
        _x.start = start;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IntegerRange[");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("maximum=");
        b.append(this.maximum);
        b.append(", ");
        b.append("minimum=");
        b.append(this.minimum);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
