package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "logoUrl", 
    "marketingUrl", 
    "privacyStatementUrl", 
    "supportUrl", 
    "termsOfServiceUrl"})
@JsonInclude(Include.NON_NULL)
public class InformationalUrl implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("logoUrl")
    protected String logoUrl;

    @JsonProperty("marketingUrl")
    protected String marketingUrl;

    @JsonProperty("privacyStatementUrl")
    protected String privacyStatementUrl;

    @JsonProperty("supportUrl")
    protected String supportUrl;

    @JsonProperty("termsOfServiceUrl")
    protected String termsOfServiceUrl;

    protected InformationalUrl() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.informationalUrl";
    }

    @Property(name="logoUrl")
    @JsonIgnore
    public Optional<String> getLogoUrl() {
        return Optional.ofNullable(logoUrl);
    }

    public InformationalUrl withLogoUrl(String logoUrl) {
        InformationalUrl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationalUrl");
        _x.logoUrl = logoUrl;
        return _x;
    }

    @Property(name="marketingUrl")
    @JsonIgnore
    public Optional<String> getMarketingUrl() {
        return Optional.ofNullable(marketingUrl);
    }

    public InformationalUrl withMarketingUrl(String marketingUrl) {
        InformationalUrl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationalUrl");
        _x.marketingUrl = marketingUrl;
        return _x;
    }

    @Property(name="privacyStatementUrl")
    @JsonIgnore
    public Optional<String> getPrivacyStatementUrl() {
        return Optional.ofNullable(privacyStatementUrl);
    }

    public InformationalUrl withPrivacyStatementUrl(String privacyStatementUrl) {
        InformationalUrl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationalUrl");
        _x.privacyStatementUrl = privacyStatementUrl;
        return _x;
    }

    @Property(name="supportUrl")
    @JsonIgnore
    public Optional<String> getSupportUrl() {
        return Optional.ofNullable(supportUrl);
    }

    public InformationalUrl withSupportUrl(String supportUrl) {
        InformationalUrl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationalUrl");
        _x.supportUrl = supportUrl;
        return _x;
    }

    @Property(name="termsOfServiceUrl")
    @JsonIgnore
    public Optional<String> getTermsOfServiceUrl() {
        return Optional.ofNullable(termsOfServiceUrl);
    }

    public InformationalUrl withTermsOfServiceUrl(String termsOfServiceUrl) {
        InformationalUrl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationalUrl");
        _x.termsOfServiceUrl = termsOfServiceUrl;
        return _x;
    }

    public InformationalUrl withUnmappedField(String name, Object value) {
        InformationalUrl _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String logoUrl;
        private String marketingUrl;
        private String privacyStatementUrl;
        private String supportUrl;
        private String termsOfServiceUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            this.changedFields = changedFields.add("logoUrl");
            return this;
        }

        public Builder marketingUrl(String marketingUrl) {
            this.marketingUrl = marketingUrl;
            this.changedFields = changedFields.add("marketingUrl");
            return this;
        }

        public Builder privacyStatementUrl(String privacyStatementUrl) {
            this.privacyStatementUrl = privacyStatementUrl;
            this.changedFields = changedFields.add("privacyStatementUrl");
            return this;
        }

        public Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            this.changedFields = changedFields.add("supportUrl");
            return this;
        }

        public Builder termsOfServiceUrl(String termsOfServiceUrl) {
            this.termsOfServiceUrl = termsOfServiceUrl;
            this.changedFields = changedFields.add("termsOfServiceUrl");
            return this;
        }

        public InformationalUrl build() {
            InformationalUrl _x = new InformationalUrl();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.informationalUrl";
            _x.logoUrl = logoUrl;
            _x.marketingUrl = marketingUrl;
            _x.privacyStatementUrl = privacyStatementUrl;
            _x.supportUrl = supportUrl;
            _x.termsOfServiceUrl = termsOfServiceUrl;
            return _x;
        }
    }

    private InformationalUrl _copy() {
        InformationalUrl _x = new InformationalUrl();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.logoUrl = logoUrl;
        _x.marketingUrl = marketingUrl;
        _x.privacyStatementUrl = privacyStatementUrl;
        _x.supportUrl = supportUrl;
        _x.termsOfServiceUrl = termsOfServiceUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InformationalUrl[");
        b.append("logoUrl=");
        b.append(this.logoUrl);
        b.append(", ");
        b.append("marketingUrl=");
        b.append(this.marketingUrl);
        b.append(", ");
        b.append("privacyStatementUrl=");
        b.append(this.privacyStatementUrl);
        b.append(", ");
        b.append("supportUrl=");
        b.append(this.supportUrl);
        b.append(", ");
        b.append("termsOfServiceUrl=");
        b.append(this.termsOfServiceUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
