package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "confidenceScore", 
    "userHasVerifiedAccuracy"})
@JsonInclude(Include.NON_NULL)
public class InferenceData implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidenceScore")
    protected Double confidenceScore;

    @JsonProperty("userHasVerifiedAccuracy")
    protected Boolean userHasVerifiedAccuracy;

    protected InferenceData() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.inferenceData";
    }

    @Property(name="confidenceScore")
    @JsonIgnore
    public Optional<Double> getConfidenceScore() {
        return Optional.ofNullable(confidenceScore);
    }

    public InferenceData withConfidenceScore(Double confidenceScore) {
        InferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inferenceData");
        _x.confidenceScore = confidenceScore;
        return _x;
    }

    @Property(name="userHasVerifiedAccuracy")
    @JsonIgnore
    public Optional<Boolean> getUserHasVerifiedAccuracy() {
        return Optional.ofNullable(userHasVerifiedAccuracy);
    }

    public InferenceData withUserHasVerifiedAccuracy(Boolean userHasVerifiedAccuracy) {
        InferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inferenceData");
        _x.userHasVerifiedAccuracy = userHasVerifiedAccuracy;
        return _x;
    }

    public InferenceData withUnmappedField(String name, Object value) {
        InferenceData _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double confidenceScore;
        private Boolean userHasVerifiedAccuracy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
            this.changedFields = changedFields.add("confidenceScore");
            return this;
        }

        public Builder userHasVerifiedAccuracy(Boolean userHasVerifiedAccuracy) {
            this.userHasVerifiedAccuracy = userHasVerifiedAccuracy;
            this.changedFields = changedFields.add("userHasVerifiedAccuracy");
            return this;
        }

        public InferenceData build() {
            InferenceData _x = new InferenceData();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.inferenceData";
            _x.confidenceScore = confidenceScore;
            _x.userHasVerifiedAccuracy = userHasVerifiedAccuracy;
            return _x;
        }
    }

    private InferenceData _copy() {
        InferenceData _x = new InferenceData();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidenceScore = confidenceScore;
        _x.userHasVerifiedAccuracy = userHasVerifiedAccuracy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InferenceData[");
        b.append("confidenceScore=");
        b.append(this.confidenceScore);
        b.append(", ");
        b.append("userHasVerifiedAccuracy=");
        b.append(this.userHasVerifiedAccuracy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
